% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_ard_continuous.R
\name{tbl_ard_continuous}
\alias{tbl_ard_continuous}
\title{Summarize continuous variable}
\usage{
tbl_ard_continuous(
  cards,
  variable,
  include,
  by = NULL,
  label = NULL,
  statistic = everything() ~ "{median} ({p25}, {p75})",
  value = NULL
)
}
\arguments{
\item{cards}{(\code{card})\cr
An ARD object of class \code{"card"} typically created with \verb{cards::ard_*()} functions.}

\item{variable}{(\code{string})\cr
A single variable name of the continuous variable being summarized.}

\item{include}{(\code{character})\cr
Character vector of the categorical variables to}

\item{by}{(\code{string})\cr
A single variable name of the stratifying variable.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
Used to override default labels in summary table, e.g. \code{list(age = "Age, years")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies summary statistics to display for each variable.  The default is
\code{everything() ~ "{median} ({p25}, {p75})"}.}

\item{value}{(\code{\link[=syntax]{formula-list-selector}})\cr
Supply a value to display a variable on a single row, printing the
results for the variable associated with the value (similar to a
\code{'dichotomous'} display in \code{tbl_summary()}).}
}
\value{
a gtsummary table of class \code{"tbl_ard_summary"}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
Summarize a continuous variable by one or more categorical variables
}
\examples{
library(cards)

# Example 1 ----------------------------------
# the primary ARD with the results
ard_continuous(
  # the order variables are passed is important for the `by` variable.
  # 'trt' is the column stratifying variable and needs to be listed first.
  trial, by = c(trt, grade), variables = age
) |>
  # adding OPTIONAL information about the summary variables
  bind_ard(
    # add univariate trt tabulation
    ard_categorical(trial, variables = trt),
    # add missing and attributes ARD
    ard_missing(trial, by = c(trt, grade), variables = age),
    ard_attributes(trial, variables = c(trt, grade, age))
  ) |>
  tbl_ard_continuous(by = "trt", variable = "age", include = "grade")

# Example 2 ----------------------------------
# the primary ARD with the results
ard_continuous(trial, by = grade, variables = age) |>
  # adding OPTIONAL information about the summary variables
  bind_ard(
    # add missing and attributes ARD
    ard_missing(trial, by = grade, variables = age),
    ard_attributes(trial, variables = c(grade, age))
  ) |>
  tbl_ard_continuous(variable = "age", include = "grade")
}
