% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_regression.R
\name{tbl_regression}
\alias{tbl_regression}
\alias{tbl_regression.default}
\title{Display regression model results in table}
\usage{
tbl_regression(x, ...)

\method{tbl_regression}{default}(
  x,
  label = NULL,
  exponentiate = FALSE,
  include = everything(),
  show_single_row = NULL,
  conf.level = NULL,
  intercept = FALSE,
  estimate_fun = NULL,
  pvalue_fun = NULL,
  tidy_fun = NULL,
  add_estimate_to_reference_rows = FALSE,
  conf.int = NULL,
  ...
)
}
\arguments{
\item{x}{Regression model object}

\item{...}{Not used}

\item{label}{List of formulas specifying variables labels,
e.g. \code{list(age ~ "Age", stage ~ "Path T Stage")}}

\item{exponentiate}{Logical indicating whether to exponentiate the
coefficient estimates. Default is \code{FALSE}.}

\item{include}{Variables to include in output. Input may be a vector of
quoted variable names, unquoted variable names, or tidyselect select helper
functions. Default is \code{everything()}.}

\item{show_single_row}{By default categorical variables are printed on
multiple rows.  If a variable is dichotomous (e.g. Yes/No) and you wish to print
the regression coefficient on a single row, include the variable name(s)
here--quoted and unquoted variable name accepted.}

\item{conf.level}{Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{intercept}{Logical argument indicating whether to include the intercept
in the output.  Default is \code{FALSE}}

\item{estimate_fun}{Function to round and format coefficient estimates.
Default is \link{style_sigfig} when the coefficients are not transformed, and
\link{style_ratio} when the coefficients have been exponentiated.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{tidy_fun}{Option to specify a particular tidier function for the
model. Default is to use \code{broom::tidy}, but if an error occurs
then tidying of the model is attempted with \code{parameters::model_parameters()},
if installed.}

\item{add_estimate_to_reference_rows}{add a reference value. Default is FALSE}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the output. Defaults to \code{TRUE}.}
}
\value{
A \code{tbl_regression} object
}
\description{
This function takes a regression model object and returns a formatted table
that is publication-ready. The function is highly customizable
allowing the user to obtain a bespoke summary table of the
regression model results. Review the
\href{https://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html}{tbl_regression vignette}
for detailed examples.
}
\section{Methods}{


The default method for \code{tbl_regression()} model summary uses \code{broom::tidy(x)}
to perform the initial tidying of the model object. There are, however,
a few models that use \link[=tbl_regression_methods]{modifications}.
\itemize{
\item \code{"parsnip/workflows"}: If the model was prepared using parsnip/workflows,
the original model fit is extracted and the original \verb{x=} argument
is replaced with the model fit. This will typically go unnoticed; however,if you've
provided a custom tidier in \verb{tidy_fun=} the tidier will be applied to the model
fit object and not the parsnip/workflows object.
\item \code{"survreg"}: The scale parameter is removed, \code{broom::tidy(x) \%>\% dplyr::filter(term != "Log(scale)")}
\item \code{"multinom"}: This multinomial outcome is complex, with one line per covariate per outcome (less the reference group)
\item \code{"gam"}: Uses the internal tidier \code{tidy_gam()} to print both parametric and smooth terms.
\item \code{"lmerMod"}, \code{"glmerMod"}, \code{"glmmTMB"}, \code{"glmmadmb"}, \code{"stanreg"}, \code{"brmsfit"}: These mixed effects
models use \code{broom.mixed::tidy(x, effects = "fixed")}. Specify \code{tidy_fun = broom.mixed::tidy}
to print the random components.
}

This list is not exhaustive, and care should be taken for each number reported.
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_regression_ex1.png}{options: width=64\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_regression_ex2.png}{options: width=50\%}}

\if{html}{Example 3}

\if{html}{\figure{tbl_regression_ex3.png}{options: width=50\%}}
}

\examples{
\donttest{
# Example 1 ----------------------------------
library(survival)
tbl_regression_ex1 <-
  coxph(Surv(ttdeath, death) ~ age + marker, trial) \%>\%
  tbl_regression(exponentiate = TRUE)

# Example 2 ----------------------------------
tbl_regression_ex2 <-
  glm(response ~ age + grade, trial, family = binomial(link = "logit")) \%>\%
  tbl_regression(exponentiate = TRUE)

# Example 3 ----------------------------------
suppressMessages(library(lme4))
tbl_regression_ex3 <-
  glmer(am ~ hp + (1 | gear), mtcars, family = binomial) \%>\%
  tbl_regression(exponentiate = TRUE)
}
}
\seealso{
See tbl_regression \href{https://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html}{vignette} for detailed examples

Review \link[=syntax]{list, formula, and selector syntax} used throughout gtsummary

Other tbl_regression tools: 
\code{\link{add_global_p}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{combine_terms}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify}},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
