% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.R
\name{inline_text.tbl_summary}
\alias{inline_text.tbl_summary}
\alias{inline_text.tbl_svysummary}
\title{Report statistics from summary tables inline}
\usage{
\method{inline_text}{tbl_summary}(
  x,
  variable,
  column = NULL,
  level = NULL,
  pattern = NULL,
  pvalue_fun = NULL,
  ...
)

\method{inline_text}{tbl_svysummary}(
  x,
  variable,
  column = NULL,
  level = NULL,
  pattern = NULL,
  pvalue_fun = NULL,
  ...
)
}
\arguments{
\item{x}{Object created from  \link{tbl_summary}}

\item{variable}{Variable name of statistic to present}

\item{column}{Column name to return from \code{x$table_body}.
Can also pass the level of a by variable.}

\item{level}{Level of the variable to display for categorical variables.
Can also specify the 'Unknown' row.  Default is \code{NULL}}

\item{pattern}{String indicating the statistics to return.
Uses \link[glue:glue]{glue::glue} formatting. Default is pattern shown in \code{tbl_summary()} output}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{...}{Not used}
}
\value{
A string reporting results from a gtsummary table
}
\description{
Extracts and returns statistics from a \code{tbl_summary} object for
inline reporting in an R markdown document. Detailed examples in the
\href{http://www.danieldsjoberg.com/gtsummary/articles/inline_text.html}{inline_text vignette}
}
\examples{
t1 <- trial[c("trt", "grade")] \%>\% tbl_summary(by = trt) \%>\% add_p()

inline_text(t1, variable = grade, level = "I", column = "Drug A", pattern = "{n}/{N} ({p})\%")
inline_text(t1, variable = grade, column = "p.value")
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n.tbl_summary}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{modify}},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_summary tools}
