% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-summarize_continuous.R
\name{summarize_continuous}
\alias{summarize_continuous}
\title{Calculates and formats summary statistics for continuous data}
\usage{
summarize_continuous(data, variable, by, digits, var_label, stat_display,
  missing)
}
\arguments{
\item{data}{data frame}

\item{variable}{Character variable name in \code{data} that will be tabulated}

\item{by}{Character variable name in \code{data} that Summary statistics for
\code{variable} are stratified}

\item{digits}{integer indicating the number of decimal places to be used.}

\item{var_label}{string label}

\item{stat_display}{String that specifies the format of the displayed statistics.
The syntax follows \code{\link[glue]{glue}} inputs with n, N, and p as input options.}

\item{missing}{whether to include \code{NA} values in the table. \code{missing} controls
if the table includes counts of \code{NA} values: the allowed values correspond to
never (\code{"no"}), only if the count is positive (\code{"ifany"}) and even for
zero counts (\code{"always"}). Default is \code{"ifany"}.}
}
\value{
formatted summary statistics in a tibble.
}
\description{
Calculates and formats summary statistics for continuous data
}
\keyword{internal}
