% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_gtfs.R
\name{new_gtfs}
\alias{new_gtfs}
\title{GTFS object constructor}
\usage{
new_gtfs(x, subclass = character(), ...)
}
\arguments{
\item{x}{A GTFS-like object (either a GTFS object or a named list). Each
element must represent a distinct GTFS text file.}

\item{subclass}{A character vector. Subclasses to be assigned to the
\code{gtfs} object.}

\item{...}{Name-value pairs. Additional attributes.}
}
\value{
A GTFS object: a named list of data frames, each one corresponding to
a distinct GTFS text file, with \code{gtfs} and \code{list} classes.
}
\description{
Creates a GTFS object. Mostly useful for package authors who may want to
either create \code{gtfs} objects in their packages or create subclasses of
the main \code{gtfs} class. The usage of this function assumes some knowledge
on \code{gtfs} objects, thus inputs are not extensively checked. See
\code{\link{assert_gtfs}} for more thorough checks.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")

tmpdir <- tempfile(pattern = "new_gtfs_example")
zip::unzip(gtfs_path, exdir = tmpdir)

agency <- data.table::fread(file.path(tmpdir, "agency.txt"))
stops <- data.table::fread(file.path(tmpdir, "stops.txt"))
routes <- data.table::fread(file.path(tmpdir, "routes.txt"))
trips <- data.table::fread(file.path(tmpdir, "trips.txt"))
stop_times <- data.table::fread(file.path(tmpdir, "stop_times.txt"))
calendar <- data.table::fread(file.path(tmpdir, "calendar.txt"))

txt_files <- list(
  agency = agency,
  stops = stops,
  routes = routes,
  trips = trips,
  stop_times = stop_times,
  calendar = calendar
)

gtfs <- new_gtfs(txt_files)

class(gtfs)
names(gtfs)

}
\seealso{
Other constructors: 
\code{\link{assert_gtfs}()}
}
\concept{constructors}
