% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_spanner_delim}
\alias{tab_spanner_delim}
\title{Create column labels and spanners via delimited names}
\usage{
tab_spanner_delim(
  data,
  delim,
  columns = everything(),
  split = c("last", "first")
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{delim}{The delimiter to use to split an input column name. The
delimiter supplied will be autoescaped for the internal splitting
procedure. The first component of the split will become the spanner column
label (and its ID value, used for styling or for the addition of footnotes
in those locations) and the second component will be the column label.}

\item{columns}{An optional vector of column names that this operation should
be limited to. The default is to consider all columns in the table.}

\item{split}{Should the delimiter splitting occur from the \code{"last"} instance
of the \code{delim} character or from the \code{"first"}? By default, column name
splitting begins at the last instance of the delimiter.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
This function will split selected delimited column names such that the first
components (LHS) are promoted to being spanner column labels, and the
secondary components (RHS) will become the column labels. Please note that
reference to individual columns must continue to be the column names from the
input table data (which are unique by necessity).
}
\details{
If we look to the column names in the \code{iris} dataset as an example of how
\code{tab_spanner_delim()} might be useful, we find the names \code{Sepal.Length},
\code{Sepal.Width}, \code{Petal.Length}, \code{Petal.Width}. From this naming system, it's
easy to see that the \code{Sepal} and \code{Petal} can group together the repeated
common \code{Length} and \code{Width} values. In your own datasets, we can avoid a
lengthy relabeling with \code{\link[=cols_label]{cols_label()}} if column names can be fashioned
beforehand to contain both the spanner column label and the column label. An
additional advantage is that the column names in the input table data remain
unique even though there may eventually be repeated column labels in the
rendered output table).
}
\section{Figures}{

\if{html}{\figure{man_tab_spanner_delim_1.png}{options: width=100\%}}
}

\section{Function ID}{

2-3
}

\examples{
# Use `iris` to create a gt table; split
# any columns that are dot-separated
# between column spanner labels (first
# part) and column labels (second part)
tab_1 <-
  iris \%>\%
  dplyr::group_by(Species) \%>\%
  dplyr::slice(1:4) \%>\%
  gt() \%>\%
  tab_spanner_delim(delim = ".")

}
\seealso{
Other Create or Modify Parts: 
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style}()}
}
\concept{Create or Modify Parts}
