% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{illness}
\alias{illness}
\title{Lab tests for one suffering from an illness}
\format{
A tibble with 39 rows and 11 variables:
\describe{
\item{test}{The name of the test.}
\item{units}{The measurement units for the test.}
\item{day_3,day_4,day_5,day_6,day_7,day_8,day_9}{Measurement values
associated with each test administered from days 3 to 9. An \code{NA} value
indicates that the test could not be performed that day.}
\item{norm_l,norm_u}{Lower and upper bounds for the normal range associated
with the test.}
}
}
\usage{
illness
}
\description{
A dataset with artificial daily lab data for a patient with Yellow Fever
(YF). The table comprises laboratory findings for the patient from day 3 of
illness onset until day 9 (after which the patient died). YF viral DNA was
found in serum samples from day 3, where the viral load reached 14,000 copies
per mL. Several medical interventions were taken to help the patient,
including the administration of fresh frozen plasma, platelets, red cells,
and coagulation factor VIII. The patient also received advanced support
treatment in the form of mechanical ventilation and plasmapheresis. Though
the patient's temperature remained stable during their illness,
unfortunately, the patient's condition did not improve. On days 7 and 8, the
patient's health declined further, with symptoms such as nosebleeds,
gastrointestinal bleeding, and hematoma.
}
\details{
The various tests are identified in the \code{test} column. The following listing
provides the full names of any abbreviations seen in that column.

\itemize{
\item \code{"WBC"}: white blood cells.
\item \code{"RBC"}: red blood cells.
\item \code{"Hb"}: hemoglobin.
\item \code{"PLT"}: platelets.
\item \code{"ALT"}: alanine aminotransferase.
\item \code{"AST"}: aspartate aminotransferase.
\item \code{"TBIL"}: total bilirubin.
\item \code{"DBIL"}: direct bilirubin.
\item \code{"NH3"}: hydrogen nitride.
\item \code{"PT"}: prothrombin time.
\item \code{"APTT"}: activated partial thromboplastin time.
\item \code{"PTA"}: prothrombin time activity.
\item \code{"DD"}: D-dimer.
\item \code{"FDP"}: fibrinogen degradation products.
\item \code{"LDH"}: lactate dehydrogenase.
\item \code{"HBDH"}: hydroxybutyrate dehydrogenase.
\item \code{"CK"}: creatine kinase.
\item \code{"CKMB"}: the MB fraction of creatine kinase.
\item \code{"BNP"}: B-type natriuetic peptide.
\item \code{"MYO"}: myohemoglobin.
\item \code{"TnI"}: troponin inhibitory.
\item \code{"CREA"}: creatinine.
\item \code{"BUN"}: blood urea nitrogen.
\item \code{"AMY"}: amylase.
\item \code{"LPS"}: lipase.
\item \code{"K"}: kalium.
\item \code{"Na"}: sodium.
\item \code{"Cl"}: chlorine.
\item \code{"Ca"}: calcium.
\item \code{"P"}: phosphorus.
\item \code{"Lac"}: lactate, blood.
\item \code{"CRP"}: c-reactive protein.
\item \code{"PCT"}: procalcitonin.
\item \code{"IL-6"}: interleukin-6.
\item \code{"CD3+CD4+"}: CD4+T lymphocytes.
\item \code{"CD3+CD8+"}: CD8+T lymphocytes.
}
}
\section{Examples}{


Here is a glimpse at the data available in \code{illness}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::glimpse(illness)
#> Rows: 39
#> Columns: 11
#> $ test   <chr> "Viral load", "WBC", "Neutrophils", "RBC", "Hb", "PLT", "ALT", ~
#> $ units  <chr> "copies per mL", "x10^9 / L", "x10^9 / L", "x10^12 / L", "g / L~
#> $ day_3  <dbl> 12000.000, 5.260, 4.870, 5.720, 153.000, 67.000, 12835.000, 236~
#> $ day_4  <dbl> 4200.000, 4.260, 4.720, 5.980, 135.000, 38.600, 12632.000, 2136~
#> $ day_5  <dbl> 1600.000, 9.920, 7.920, 4.230, 126.000, 27.400, 6426.700, 14730~
#> $ day_6  <dbl> 830.000, 10.490, 18.210, 4.830, 115.000, 26.200, 4263.100, 8691~
#> $ day_7  <dbl> 760.000, 24.770, 22.080, 4.120, 75.000, 74.100, 1623.700, 2189.~
#> $ day_8  <dbl> 520.000, 30.260, 27.170, 2.680, 87.000, 36.200, 672.600, 1145.0~
#> $ day_9  <dbl> 250.000, 19.030, 16.590, 3.320, 95.000, 25.600, 512.400, 782.50~
#> $ norm_l <dbl> NA, 4.0, 2.0, 4.0, 120.0, 100.0, 9.0, 15.0, 0.0, 0.0, 10.0, 9.4~
#> $ norm_u <dbl> NA, 10.000, 8.000, 5.500, 160.000, 300.000, 50.000, 40.000, 18.~
}\if{html}{\out{</div>}}
}

\section{Dataset ID and Badge}{

DATA-10

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_illness.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.10.0} (October 7, 2023)
}

\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{gtcars}},
\code{\link{metro}},
\code{\link{pizzaplace}},
\code{\link{rx_addv}},
\code{\link{rx_adsl}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
