% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{px}
\alias{px}
\title{Helper for providing a numeric value as pixels value}
\usage{
px(x)
}
\arguments{
\item{x}{\emph{Numeric length in pixels}

\verb{scalar<numeric|integer>} // \strong{required}

The numeric value to format as a string (e.g., \code{"12px"}) for some
\code{\link[=tab_options]{tab_options()}} arguments that can take values as units of pixels (e.g.,
\code{table.font.size}).}
}
\value{
A character vector with a single value in pixel units.
}
\description{
For certain parameters, a length value is required. Examples include the
setting of font sizes (e.g., in \code{\link[=cell_text]{cell_text()}}) and thicknesses of lines
(e.g., in \code{\link[=cell_borders]{cell_borders()}}). Setting a length in pixels with \code{px()} allows
for an absolute definition of size as opposed to the analogous helper
function \code{\link[=pct]{pct()}}.
}
\section{Examples}{


Use the \code{\link{exibble}} dataset to create a \strong{gt} table. Inside of the
\code{\link[=cell_text]{cell_text()}} call (which is itself inside of \code{\link[=tab_style]{tab_style()}}), we'll use the
\code{px()} helper function to define the font size for the column labels in units
of pixels.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt() |>
  tab_style(
    style = cell_text(size = px(20)),
    locations = cells_column_labels()
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_px_1.png" alt="This image of a table was generated from the first code example in the `px()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-3
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{define_units}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{random_id}()},
\code{\link{stub}()},
\code{\link{system_fonts}()}
}
\concept{helper functions}
