% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_maxdensity}
\alias{gsw_CT_maxdensity}
\title{Conservative Temperature at Maximum Density}
\usage{
gsw_CT_maxdensity(SA, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
Conservative Temperature [ degC ]
}
\description{
Conservative Temperature at Maximum Density
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <-  c(     10,      50,     125,     250,     600,    1000)
CT <- gsw_CT_maxdensity(SA, p)
stopifnot(all.equal(CT, c(-3.731407240089855, -3.861137427731664, -4.060390602245942,
                          -4.306222571955388, -5.089240667106197, -6.028034316992341)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_maxdensity.html}
}
\seealso{
Other things related to density: 
\code{\link{gsw_CT_from_rho}()},
\code{\link{gsw_SA_from_rho}()},
\code{\link{gsw_alpha_on_beta}()},
\code{\link{gsw_alpha_wrt_t_exact}()},
\code{\link{gsw_alpha_wrt_t_ice}()},
\code{\link{gsw_alpha}()},
\code{\link{gsw_beta_const_t_exact}()},
\code{\link{gsw_beta}()},
\code{\link{gsw_pot_rho_t_exact}()},
\code{\link{gsw_rho_alpha_beta}()},
\code{\link{gsw_rho_first_derivatives_wrt_enthalpy}()},
\code{\link{gsw_rho_first_derivatives}()},
\code{\link{gsw_rho_ice}()},
\code{\link{gsw_rho_t_exact}()},
\code{\link{gsw_rho}()},
\code{\link{gsw_sigma0}()},
\code{\link{gsw_sigma1}()},
\code{\link{gsw_sigma2}()},
\code{\link{gsw_sigma3}()},
\code{\link{gsw_sigma4}()},
\code{\link{gsw_specvol_alpha_beta}()},
\code{\link{gsw_specvol_anom_standard}()},
\code{\link{gsw_specvol_ice}()},
\code{\link{gsw_specvol_t_exact}()},
\code{\link{gsw_specvol}()}
}
\concept{things related to density}
