% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_first_derivatives}
\alias{gsw_pt_first_derivatives}
\title{First Derivatives of Potential Temperature}
\usage{
gsw_pt_first_derivatives(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
A list containing \code{pt_SA} [ K/(g/kg) ], the derivative of
potential temperature with respect to Absolute Salinity,
and \code{pt_CT} [ unitless ], the derivative of potential temperature
with respect to Conservative Temperature.
}
\description{
First Derivatives of Potential Temperature
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
r <- gsw_pt_first_derivatives(SA, CT)
expect_equal(r$pt_SA, c(0.041863223165431, 0.041452303483011, 0.034682095247246,
                      0.018711079068408, 0.014079958329844, 0.010577326129948))
expect_equal(r$pt_CT, c(0.997192967140242, 0.997451686508335, 0.998357568277750,
                      0.999996224076267, 1.000283719083268, 1.000525947028218))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_first_derivatives.html}
}
