% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\docType{data}
\name{saar}
\alias{saar}
\title{Global SA lookup file}
\description{
This dataset is not intended for users, but rather for internal use
within the \code{gsw} package. The dataset stores the 1.4M lookup
table defined in the 8.3M file \code{src/gsw_saar_data.c} in the C
library. (The .c file exceeds CRAN limitations on size.)
}
\details{
The data are designed to replace C elements defined as below
in \code{src/gsw_saar_data.c}:
\preformatted{
    static int	gsw_nx=91, gsw_ny=45, gsw_nz=45;
    static double	longs_ref[91];
    static double	lats_ref[45];
    static double	p_ref[45];
    static double	ndepth_ref[4095];
    static double	saar_ref[184275];
    static double	delta_sa_ref[184275];
}

R storage is in a list named \code{saar}, with elements named
as in the C code, i.e. \code{gsw_nx} etc.

C storage for these variables is allocated as needed,
and the data are inserted, when \code{gsw} is launched.
Thus, the existing C library code "knows" about the data
as local storage, which keeps alterations to the C library to
a minimum.

The code used to create the RDA file (using the Fortran data
file, version 3.0.3) is given below.
\preformatted{
    gsw_nx <- 91
    gsw_ny <- 45
    gsw_nz <- 45
    f <- file("~/src/gsw_fortran_v3_03/gsw_data_v3_0.dat", "r")
    longs_ref <- scan(f, double(), n=gsw_nx)
    lats_ref <- scan(f, double(), n=gsw_ny)
    p_ref <- scan(f, double(), n=gsw_nz)
    ndepth_ref <- scan(f, double(), n=gsw_nx*gsw_ny)
    saar_ref <- scan(f, double(), n=gsw_nx*gsw_ny*gsw_nz)
    delta_sa_ref <- scan(f, double(), n=gsw_nx*gsw_ny*gsw_nz)
    saar <- list(gsw_nx=gsw_nx, gsw_ny=gsw_ny, gsw_nz=gsw_nz,
                 longs_ref=longs_ref, lats_ref=lats_ref, p_ref=p_ref, ndepth_ref=ndepth_ref,
                 saar_ref=saar_ref, delta_sa_ref=delta_sa_ref)
    save(saar, file="saar.rda")
    tools::resaveRdaFiles("saar.rda")
    close(f)
}
}

