% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impinvar.R
\name{impinvar}
\alias{impinvar}
\alias{impinvar.Arma}
\alias{impinvar.default}
\title{Impulse invariance method for A/D filter conversion}
\usage{
impinvar(b, ...)

\method{impinvar}{Arma}(b, ...)

\method{impinvar}{default}(b, a, fs = 1, tol = 1e-04, ...)
}
\arguments{
\item{b}{coefficients of numerator polynomial}

\item{...}{additional arguments (not used)}

\item{a}{coefficients of denominator polynomial}

\item{fs}{sampling frequency (Default: 1 Hz)}

\item{tol}{tolerance. Default: 0.0001}
}
\value{
A list of class \code{\link{Arma}} containing numerator and
  denominator polynomial filter coefficients of the A/D converted filter.
}
\description{
Convert analog filter with coefficients b and a to digital, conserving
impulse response.
}
\details{
Because \code{impinvar} is generic, it can also accept input of class
\code{\link{Arma}}.
}
\examples{
f <- 2
fs <- 10
but <- butter(6, 2 * pi * f, 'low', 's')
zbut <- impinvar(but, fs)
freqz(zbut, n = 1024, fs = fs)

}
\seealso{
\code{\link{invimpinvar}}
}
\author{
Tony Richardson, \email{arichard@stark.cc.oh.us},\cr
 Ben Abbott, \email{bpabbott@mac.com},\cr
  adapted by John W. Eaton.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}
}
