% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{gr_fill_gaps}
\alias{gr_fill_gaps}
\title{Fill missing daily data}
\usage{
gr_fill_gaps(hdata, autocorr = 0.7, nobserv = NULL)
}
\arguments{
\item{hdata}{\code{data.frame} with at least two columns, where the first column is \code{Date}, and the remaining columns have numeric type.}

\item{autocorr}{Autocorrelation value that defines possible length of the period that can be filled. Defaults to 0.7.  If \code{nobserv} parameter is set, then this parameter is ignored. If both parameters are \code{NULL}, then all gaps are filled disregard of their lengths (not recommended).}

\item{nobserv}{Maximum number of contiguous observations that can be interpolated. Defaults to \code{NULL}. If this parameter is set, then \code{autocorr} parameter is ignored. If both parameters are \code{NULL}, then all gaps are filled disregard of their lengths (not recommended).}
}
\value{
\code{data.frame} which is a filled version of \code{hdata}
}
\description{
Use the function to fill the missing daily data by linear interpolation. These can be both missing dates and missing runoff or temperature values. A preliminary summary of missing data can be viewed by \code{\link[=gr_get_gaps]{gr_get_gaps()}}
}
\examples{
library(grwat)
library(dplyr)

# example Spas-Zagorye data is included with grwat package
path = system.file("extdata", "spas-zagorye.txt", 
                   package = "grwat")

hdata_raw = read.delim(path, header = FALSE, 
                       sep = ' ', na.strings = c('-999', '-999.0', '-'),
                       col.names = c('d', 'm', 'y', 'q'))

hdata = hdata_raw \%>\% 
  transmute(Date = lubridate::make_date(y, m, d), 
            Q = q)

head(hdata)

# identify gaps
gr_get_gaps(hdata) 

# fill gaps
fhdata = gr_fill_gaps(hdata, autocorr = 0.8)

# check the results
gr_get_gaps(fhdata)

# fill gaps
fhdata = gr_fill_gaps(hdata, nobserv = 7)

# check the results
gr_get_gaps(fhdata)
}
