% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{add_lines}
\alias{add_lines}
\title{Add data to a ggplot}
\usage{
add_lines(
  data,
  ax = NULL,
  y_key = "dBM_smooth",
  x_key = "DOY",
  style = "line",
  label = NULL,
  ...
)
}
\arguments{
\item{data}{data.frame or similar object interpretable by ggplot.}

\item{ax}{list as returned by ggplot() and related functions.}

\item{x_key, y_key}{Column names in *data* to be plotted.}

\item{style}{XXX in ggplot geom_XXX to use.}

\item{label}{Codename for this line to be used in legend creation. If 
NULL, use *y_key*.}

\item{...}{All further arguments are passed to the selected ggplot geom.}
}
\value{
ax A ggplot list (like the input *ax*).
}
\description{
Add a lineplot of the *x_key* and *y_key* columns in *data* to the 
supplied ggplot object *ax*. If none is supplied, a new one is created.
}
\examples{
library(ggplot2)
# Add first set of data
ax = add_lines(mtcars, x_key = "wt", y_key = "mpg", label = "First Line")

# Add one more line to the plot
ax = add_lines(mtcars, ax = ax, x_key = "wt", y_key = "qsec", 
label = "Second Line")

print(ax)
}
