% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport1d.R
\name{north_west_corner}
\alias{north_west_corner}
\title{North-west-corner Rule}
\usage{
north_west_corner(wx, wy, threshold = 1e-15)
}
\arguments{
\item{wx}{first weight vector.}

\item{wy}{second weight vector.}

\item{threshold}{small value that indicates when a value is considered to be zero.}
}
\value{
a matrix representing the transport plan obtained by the north-west-corner rule.
}
\description{
Calculate the transport plan obtained by the north-west-corner rule.
}
\examples{
set.seed(1)
wx <- rep(1/5, 5)
wy <- runif(6)
wy <- wy / sum(wy)
north_west_corner(wx, wy)
}
