% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_survival_forest.R
\name{compute_eta}
\alias{compute_eta}
\title{Compute pseudo outcomes (based on the influence function of tau(X) for each unit)
used for CART splitting.}
\usage{
compute_eta(S.hat, C.hat, lambda.C.hat, Y.grid, Y, D, m.hat, W.centered)
}
\arguments{
\item{S.hat}{Estimates of the conditional survival function S(t, x, w).}

\item{C.hat}{Estimates of the conditional survival function for the censoring process S_C(t, x, w).}

\item{lambda.C.hat}{Estimates of the conditional hazard function for the censoring process S_C(t, x, w).}

\item{Y.grid}{The time values corresponding to S.hat and C.hat.}

\item{Y}{The event times.}

\item{D}{The censoring indicator.}

\item{m.hat}{Estimates of m(X).}

\item{W.centered}{W - W.hat.}
}
\value{
A list with the numerator and denominator of eta.
}
\description{
We compute:
eta = [sum (W - W.hat)^2 (1 / C.hat - integral_{0}^{Y_i} (lambdaC / C.hat) dt)]^(-1) ("denominator")
 * sum (Gamma / C.hat - integral_{0}^{Y_i} (lambdaC / C.hat)(W - W.hat)(Q(t) - m.hat)dt) ("numerator")
}
\details{
where
Gamma = (W - W.hat)(Y - m.hat) if D == 1 else (W - W.hat)(Q(Y) - m.hat)
Q(t) - E[T | X, W, Y >= t]
m(x) = e(X) E[T | X, W = 1] + (1 - e(X)) E[T | X, W = 0]
lambda.C = -d/dt log(C.hat(t, x, w)) is the conditional hazard function of the censoring process.

Some useful properties:
The expected survival time E[T] is the integral of the survival function S(t).
The conditional expected survival time E[T | T >= y] is y + the integral of S(t + y) / S(y).
}
\keyword{internal}
