% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_linear_forest.R
\name{ll_regression_forest}
\alias{ll_regression_forest}
\title{Local Linear forest}
\usage{
ll_regression_forest(X, Y, sample.fraction = 0.5, mtry = NULL,
  num.trees = 2000, min.node.size = NULL, honesty = TRUE,
  honesty.fraction = NULL, prune.empty.leaves = NULL,
  ci.group.size = 1, alpha = NULL, imbalance.penalty = NULL,
  clusters = NULL, samples.per.cluster = NULL,
  tune.parameters = FALSE, num.fit.trees = 10, num.fit.reps = 100,
  num.optimize.reps = 1000, num.threads = NULL, seed = NULL)
}
\arguments{
\item{X}{The covariates used in the regression.}

\item{Y}{The outcome.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty = TRUE, these subsamples will
further be cut by a factor of honesty.fraction. Default is 0.5.}

\item{mtry}{Number of variables tried for each split. Default is
\eqn{\sqrt p + 20} where p is the number of variables.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions. Default is 2000.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.
Default is 5.}

\item{honesty}{Whether or not honest splitting (i.e., sub-sample splitting) should be used. Default is TRUE.}

\item{honesty.fraction}{The fraction of data that will be used for determining splits if honesty = TRUE. Corresponds
to set J1 in the notation of the paper. When using the defaults (honesty = TRUE and
honesty.fraction = NULL), half of the data will be used for determining splits.
Default is 0.5.}

\item{prune.empty.leaves}{(experimental) If true, prunes the estimation sample tree such that no leaves
are empty. If false, keep the same tree as determined in the splits sample (if an empty leave is encountered, that
tree is skipped and does not contribute to the estimate). Setting this to false may improve performance on
small/marginally powered data, but requires more trees. Only applies if honesty is enabled. Default is TRUE.}

\item{ci.group.size}{The forest will grow ci.group.size trees on each subsample.
In order to provide confidence intervals, ci.group.size must
be at least 2. Default is 1.}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split. Default is 0.05.}

\item{imbalance.penalty}{A tuning parameter that controls how harshly imbalanced splits are penalized. Default is 0.}

\item{clusters}{Vector of integers or factors specifying which cluster each observation corresponds to.
Default is NULL (ignored).}

\item{samples.per.cluster}{If sampling by cluster, the number of observations to be sampled from
each cluster when training a tree. If NULL, we set samples.per.cluster to the size
of the smallest cluster. If some clusters are smaller than samples.per.cluster,
the whole cluster is used every time the cluster is drawn. Note that
clusters with less than samples.per.cluster observations get relatively
smaller weight than others in training the forest, i.e., the contribution
of a given cluster to the final forest scales with the minimum of
the number of observations in the cluster and samples.per.cluster. Default is NULL.}

\item{tune.parameters}{If true, NULL parameters are tuned by cross-validation; if false
NULL parameters are set to defaults. Default is FALSE.}

\item{num.fit.trees}{The number of trees in each 'mini forest' used to fit the tuning model. Default is 10.}

\item{num.fit.reps}{The number of forests used to fit the tuning model. Default is 100.}

\item{num.optimize.reps}{The number of random parameter values considered when using the model
to select the optimal parameters. Default is 1000.}

\item{num.threads}{Number of threads used in training. By default, the number of threads is set
to the maximum hardware concurrency.}

\item{seed}{The seed of the C++ random number generator.}
}
\value{
A trained local linear forest object.
}
\description{
Trains a local linear forest that can be used to estimate
the conditional mean function mu(x) = E[Y | X = x]
}
\examples{
\dontrun{
# Train a standard regression forest.
n <- 50
p <- 10
X <- matrix(rnorm(n * p), n, p)
Y <- X[, 1] * rnorm(n)
forest <- ll_regression_forest(X, Y)
}

}
