% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carer_payment.R
\name{carer_payment}
\alias{carer_payment}
\title{Carer Payment}
\usage{
carer_payment(Date = NULL, fy.year = NULL,
  carer_fortnightly_income = 0,
  carer_annual_income = carer_fortnightly_income * 26,
  carer_has_partner = FALSE, carer_n_dependants = 0L,
  carer_partner_fortnightly_income = 0,
  carer_partner_annual_income = carer_partner_fortnightly_income * 26,
  carer_assets_value = 0, carer_is_home_owner = FALSE,
  carer_illness_separated_couple = FALSE, dclad_eligible = FALSE,
  high_adat = FALSE, living_at_home = TRUE,
  receiving_other_payment = FALSE,
  care_receiver_fortnightly_income = 0,
  care_receiver_annual_income = care_receiver_fortnightly_income * 26,
  care_receiver_asset_value = 0, partner_fortnightly_income = 0,
  partner_annual_income = partner_fortnightly_income * 26,
  partner_asset_value = 0, children_fortnightly_income = 0,
  children_annual_income = children_fortnightly_income * 26,
  children_asset_value = 0, parents_fortnightly_income = 0,
  parents_annual_income = parents_fortnightly_income * 26,
  parents_asset_value = 0)
}
\arguments{
\item{Date, fy.year}{The financial year. Currently only 2015-16 is supported (the most recent survey of income and housing results).}

\item{carer_fortnightly_income, carer_annual_income}{Carer's income for means-testing purposes. Provide one but not both.}

\item{carer_has_partner}{(logical, default: \code{FALSE}) Does the carer have a partner?}

\item{carer_n_dependants}{How many dependants does the carer have? Default is zero.}

\item{carer_partner_fortnightly_income, carer_partner_annual_income}{The carer's partner's income.}

\item{carer_assets_value}{Total value of carer's household assets.}

\item{carer_is_home_owner}{(logical, default: \code{FALSE}) Does the carer own their own home?}

\item{carer_illness_separated_couple}{Is the couple separated by illness? (Affects the assets test.)}

\item{dclad_eligible}{Is the person receiving care a DCLAD (Disability Care Load Assessment) qualifying child as defined in http://guides.dss.gov.au/guide-social-security-law/1/1/q/17 ?}

\item{high_adat}{Does the person receiving care have a high ADAT (Adult Disability Assessment Tool) score as defined in http://guides.dss.gov.au/guide-social-security-law/1/1/a/78 ?}

\item{living_at_home}{Does the person receiving care live at home with their parents?}

\item{receiving_other_payment}{Is the care receiver receiving other social security payments?}

\item{care_receiver_fortnightly_income}{Care receiver's fortnightly income}

\item{care_receiver_annual_income}{Care receiver's annual income}

\item{care_receiver_asset_value}{Care receiver's asset value}

\item{partner_fortnightly_income}{Care receiver's partner's fortnightly income}

\item{partner_annual_income}{Care receiver's partner's annual income}

\item{partner_asset_value}{Care receiver's partner's asset value}

\item{children_fortnightly_income}{Care receiver's children's fortnightly income}

\item{children_annual_income}{Care receiver's children's annual income}

\item{children_asset_value}{Care receiver's children's asset value}

\item{parents_fortnightly_income}{Care receiver's parents' fortnightly income}

\item{parents_annual_income}{Care receiver's parents' annual income}

\item{parents_asset_value}{Care receiver's parents' asset value}
}
\description{
Carer payment is available to those who provide constant for a person who has a physical, intellectual, or psychiatric disability. Note that many of the arguments relate to the individual who receives the care (indicated by not starting with 'carer_'). Payment is made to the carer and not to the person receiving the care.
}
\author{
Matthew Katzen
}
