% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearmonth.R
\name{yearmonth}
\alias{yearmonth}
\title{Constructor for yearmonth objects}
\usage{
yearmonth(year = integer(), month = integer())
}
\arguments{
\item{year}{\verb{[integer]}

Vector representing the year associated with \code{month}.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{month}{\verb{[integer]}

Vector representing the month associated with `year.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}
}
\value{
A \verb{<grates_yearmonth>} object.
}
\description{
\code{yearmonth()} is a constructor for \verb{<grates_yearmonth>} objects.
}
\details{
\verb{<grates_yearmonth>} objects are stored as the number of months (starting at
0) since the Unix Epoch (1970-01-01).
}
\examples{
yearmonth(year = 2000L, month = 3L)

}
\seealso{
\code{as_yearmonth()} and \code{new_yearmonth()}.
}
