% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation.R
\name{rMixSBM}
\alias{rMixSBM}
\title{Simulate a collection of networks of a mixture of stochastic block models}
\usage{
rMixSBM(vec_n, thetaMixSBM, directed = TRUE)
}
\arguments{
\item{vec_n}{vector with number of vertices}

\item{thetaMixSBM}{K-list for a mixture with K components. Each field
is a list with the stochastic block model parameter ($pi and $gamma) and a cluster
proportion ($prop)}

\item{directed}{directed networks (TRUE by default) or undirected (FALSE)}
}
\value{
list with a list of adjacency matrices ($listGraphs), a list of
node labels ($listLatentZ) and a vector with the graph clustering ($label)
}
\description{
Simulate a collection of networks of a mixture of stochastic block models
}
\examples{
theta1 <- list(prop=.2, pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
theta2 <- list(prop=.8, pi=c(.5,.5), gamma=matrix(4:1/8,2,2))
thetaMixSBM <- list(NULL)
thetaMixSBM[[1]] <- theta1
thetaMixSBM[[2]] <- theta2
obs <- rMixSBM(vec_n=rep(10,3), thetaMixSBM)
}
