% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graphab_linkset.R
\name{get_graphab_linkset}
\alias{get_graphab_linkset}
\title{Get linkset computed in the Graphab project}
\usage{
get_graphab_linkset(proj_name, linkset, proj_path = NULL)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml is.}

\item{linkset}{A character string indicating the name of the link set
whose properties are imported. The link set has been created with Graphab
or using \code{\link{graphab_link}} function.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}
}
\value{
A data.frame with the link properties (from, to, cost-distance,
Euclidean distance)
}
\description{
The function gets a linkset computed in the Graphab project
}
\details{
See more information in Graphab 2.6 manual:
\url{https://sourcesup.renater.fr/www/graphab/download/manual-2.6-en.pdf}.
This function works if \code{link{get_graphab}} function works correctly.
}
\examples{
\dontrun{
get_graphab_linkset(proj_name = "grphb_ex",
               linkset = "lkst1")
}
}
\author{
P. Savary
}
