% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{f.nonconst}
\alias{f.nonconst}
\title{Function to compute the abundance of new or old RNA at time t for non-constant rates.}
\usage{
f.nonconst(t, f0, s, d)
}
\arguments{
\item{t}{time in h (can be a vector)}

\item{f0}{the abundance at time t=0}

\item{s}{the synthesis rate (see details)}

\item{d}{the degradation rate (see details)}
}
\value{
the RNA abundance at time t
}
\description{
The standard mass action kinetics model of gene expression arises from the differential equation
\eqn{df/dt = s(t) - d(t)  f(t)}, with s(t) being the synthesis rate at time t, d(t) the degradation rate at time t and \eqn{f0=f(0)} (the abundance at time 0).
Here, both s and d have the following form \eqn{s(t)=so+sf \cdot t^{se}}.
}
\details{
Both rates can be either (i) a single number (constant rate), (ii) a data frame with names "offset",
"factor" and "exponent" (for linear functions, see \link{ComputeNonConstantParam}; only one row allowed) or
(iii) a unary function time->rate. Functions
}
\seealso{
\link{f.nonconst.linear}
}
\concept{kinetics}
