% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{TransformSnapshot}
\alias{TransformSnapshot}
\title{Estimate parameters for a one-shot experiment.}
\usage{
TransformSnapshot(ntr, total, t, t0 = NULL, f0 = NULL, full.return = FALSE)
}
\arguments{
\item{ntr}{the new to total RNA ratio (measured)}

\item{total}{the total level of RNA (measured)}

\item{t}{the labeling duration}

\item{t0}{time before measurement at which f0 is total level (only necessary under non-steady-state conditions)}

\item{f0}{total level at t0 (only necessary under non-steady-state conditions)}

\item{full.return}{also return the provided parameters}
}
\value{
a named vector for s and d
}
\description{
Under steady state conditions it is straight-forward to estimate s and d. Otherwise, the total levels at some other time point are needed.
}
\details{
t0 must be given as the total time in between the measurement of f0 and the given ntr and total values!
}
\concept{snapshot}
