% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{SimulateKinetics}
\alias{SimulateKinetics}
\title{Simulate the kinetics of old and new RNA for given parameters.}
\usage{
SimulateKinetics(
  s = 100 * d,
  d = log(2)/hl,
  hl = 2,
  f0 = NULL,
  min.time = -1,
  max.time = 10,
  N = 1000,
  name = NULL,
  out = c("Old", "New", "Total", "NTR")
)
}
\arguments{
\item{s}{the synthesis rate (see details)}

\item{d}{the degradation rate (see details)}

\item{hl}{the RNA half-life}

\item{f0}{the abundance at time t=0}

\item{min.time}{the start time to simulate}

\item{max.time}{the end time to simulate}

\item{N}{how many time points from min.time to max.time to simuate}

\item{name}{add a Name column to the resulting data frame}

\item{out}{which values to put into the data frame}
}
\value{
a data frame containing the simulated values
}
\description{
The standard mass action kinetics model of gene expression arises from the differential equation
\eqn{df/dt = s - d  f(t)}, with s being the constant synthesis rate, d the constant degradation rate and \eqn{f0=f(0)} (the abundance at time 0).
The RNA half-life is directly related to d via \eqn{HL=log(2)/d}.
This model dictates the time evolution of old and new RNA abundance after metabolic labeling starting at time t=0.
This function simulates data according to this model.
}
\details{
Both rates can be either (i) a single number (constant rate), (ii) a data frame with names "offset",
"factor" and "exponent" (for linear functions, see \link{ComputeNonConstantParam}) or (iii) a unary function time->rate. Functions
}
\examples{
head(SimulateKinetics(hl=2))   # simulate steady state kinetics for an RNA with half-life 2h

}
\seealso{
\link{PlotSimulation} for plotting the simulation
}
\concept{kinetics}
