% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{grafzahl}
\alias{grafzahl}
\alias{grafzahl.default}
\alias{grafzahl.corpus}
\alias{textmodel_transformer}
\alias{grafzahl.character}
\title{Fine tune a pretrained Transformer model for texts}
\usage{
grafzahl(
  x,
  y = NULL,
  model_name = "xlm-roberta-base",
  regression = FALSE,
  output_dir,
  cuda = detect_cuda(),
  num_train_epochs = 4,
  train_size = 0.8,
  args = NULL,
  cleanup = TRUE,
  model_type = NULL,
  manual_seed = floor(runif(1, min = 1, max = 721831)),
  verbose = TRUE
)

\method{grafzahl}{default}(
  x,
  y = NULL,
  model_name = "xlm-roberta-base",
  regression = FALSE,
  output_dir,
  cuda = detect_cuda(),
  num_train_epochs = 4,
  train_size = 0.8,
  args = NULL,
  cleanup = TRUE,
  model_type = NULL,
  manual_seed = floor(runif(1, min = 1, max = 721831)),
  verbose = TRUE
)

\method{grafzahl}{corpus}(
  x,
  y = NULL,
  model_name = "xlm-roberta-base",
  regression = FALSE,
  output_dir,
  cuda = detect_cuda(),
  num_train_epochs = 4,
  train_size = 0.8,
  args = NULL,
  cleanup = TRUE,
  model_type = NULL,
  manual_seed = floor(runif(1, min = 1, max = 721831)),
  verbose = TRUE
)

textmodel_transformer(...)

\method{grafzahl}{character}(
  x,
  y = NULL,
  model_name = "xlmroberta",
  regression = FALSE,
  output_dir,
  cuda = detect_cuda(),
  num_train_epochs = 4,
  train_size = 0.8,
  args = NULL,
  cleanup = TRUE,
  model_type = NULL,
  manual_seed = floor(runif(1, min = 1, max = 721831)),
  verbose = TRUE
)
}
\arguments{
\item{x}{the \link{corpus} or character vector of texts on which the model will be trained. Depending on \code{train_size}, some texts will be used for cross-validation.}

\item{y}{training labels. It can either be a single string indicating which \link{docvars} of the \link{corpus} is the training labels; a vector of training labels in either character or factor; or \code{NULL} if the \link{corpus} contains exactly one column in \link{docvars} and that column is the training labels. If \code{x} is a character vector, \code{y} must be a vector of the same length.}

\item{model_name}{string indicates either 1) the model name on Hugging Face website; 2) the local path of the model}

\item{regression}{logical, if \code{TRUE}, the task is regression, classification otherwise.}

\item{output_dir}{string, location of the output model. If missing, the model will be stored in a temporary directory. Important: Please note that if this directory exists, it will be overwritten.}

\item{cuda}{logical, whether to use CUDA, default to \code{\link[=detect_cuda]{detect_cuda()}}.}

\item{num_train_epochs}{numeric, if \code{train_size} is not exactly 1.0, the maximum number of epochs to try in the "early stop" regime will be this number times 5 (i.e. 4 * 5 = 20 by default). If \code{train_size} is exactly 1.0, the number of epochs is exactly that.}

\item{train_size}{numeric, proportion of data in \code{x} and \code{y} to be used actually for training. The rest will be used for cross validation.}

\item{args}{list, additionally parameters to be used in the underlying simple transformers}

\item{cleanup}{logical, if \code{TRUE}, the \code{runs} directory generated will be removed when the training is done}

\item{model_type}{a string indicating model_type of the input model. If \code{NULL}, it will be inferred from \code{model_name}. Supported model types are available in \link{supported_model_types}.}

\item{manual_seed}{numeric, random seed}

\item{verbose}{logical, if \code{TRUE}, debug messages will be displayed}

\item{...}{paramters pass to \code{\link[=grafzahl]{grafzahl()}}}
}
\value{
a \code{grafzahl} S3 object with the following items
\item{call}{original function call}
\item{input_data}{input_data for the underlying python function}
\item{output_dir}{location of the output model}
\item{model_type}{model type}
\item{model_name}{model name}
\item{regression}{whether or not it is a regression model}
\item{levels}{factor levels of y}
\item{manual_seed}{random seed}
\item{meta}{metadata about the current session}
}
\description{
Fine tune (or train) a pretrained Transformer model for your given training labelled data \code{x} and \code{y}. The prediction task can be classification (if \code{regression} is \code{FALSE}, default) or regression (if \code{regression} is \code{TRUE}).
}
\examples{
if (detect_conda() && interactive()) {
library(quanteda)
set.seed(20190721)
## Using the default cross validation method
model1 <- grafzahl(unciviltweets, model_type = "bertweet", model_name = "vinai/bertweet-base")
predict(model1)

## Using LIME
input <- corpus(ecosent, text_field = "headline")
training_corpus <- corpus_subset(input, !gold)
model2 <- grafzahl(x = training_corpus,
                 y = "value",
                 model_name = "GroNLP/bert-base-dutch-cased")
test_corpus <- corpus_subset(input, gold)
predicted_sentiment <- predict(model2, test_corpus)
require(lime)
sentences <- c("Dijsselbloem pessimistisch over snelle stappen Grieken",
               "Aandelenbeurzen zetten koersopmars voort")
explainer <- lime(training_corpus, model2)
explanations <- explain(sentences, explainer, n_labels = 1,
                        n_features = 2)
plot_text_explanations(explanations)
}
}
\seealso{
\code{\link[=predict.grafzahl]{predict.grafzahl()}}
}
