% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_jug.R
\name{server}
\alias{server}
\title{Run basic GraphQL server}
\usage{
server(schema, port = 8000L, log = TRUE, initial_value = NULL)
}
\arguments{
\item{schema}{Schema object to use execute requests}

\item{port}{web port to serve the server from.  Set port to \code{NULL} to not run the jug server and return it.}

\item{log}{boolean that determines if server logging is done.  Defaults to TRUE}

\item{initial_value}{default value to use in \code{\link{execute_request}()}}
}
\description{
Run a basic GraphQL server with the jug package.  This server is provided to show basic interaction with GraphQL.  The server will run until the function execution is canceled.
}
\details{
\code{server()} implements the basic necessities described in \url{http://graphql.org/learn/serving-over-http/}.  There are three routes implemented:

\describe{
  \item{\code{'/'}}{GET. Returns a GraphQL formated schema definition}
  \item{\code{'/graphql'}}{GET. Executes a query.  The parameter \code{'query'} (which contains a GraphQL formatted query string) must be included.  Optional parameters include: \code{'variables'} a JSON string containing a dictionary of variables (defaults to an empty named list), \code{'operationName'} name of the particular query operation to execute (defaults to NULL), and \code{'pretty'} boolean to determine if the response should be compact (FALSE, default) or expanded (TRUE)}
  \item{\code{'/graphql'}}{POST. Executes a query.  Must provide Content-Type of either 'application/json' or 'application/graphql'.

If 'application/json' is provided, a named JSON list containing 'query', 'operationName' (optional, default = \code{NULL}), 'variables' (optional, default = list()) and 'pretty' (optional, default = \code{TRUE}).  The information will used just the same as the GET-'/graphql' route.

If 'application/graphql' is provided, the POST body will be interpreted as the query string.  All other possible parameters will take on their default value.
}
}

Using bash's curl, we can ask the server questions:
\preformatted{ #R
  # load Star Wars schema from 'execute_request' example
  example(gqlr_schema)
  # run server
  server(star_wars_schema, port = 8000)
}

\preformatted{ #bash
  # GET Schema definition
  curl '127.0.0.1:8000/'

# GET R2-D2 and his friends' names
  curl '127.0.0.1:8000/graphql?query=%7Bhero%7Bname%2Cfriends%7Bname%7D%7D%7D&pretty=TRUE'

# POST for R2-D2 and his friends' names
  curl --data '{"query":"{hero{name}}"}' '127.0.0.1:8000/graphql' # defaults to parse as JSON
  curl --data '{"query":"{hero{name}}"}' '127.0.0.1:8000/graphql' --header "Content-Type:application/json"
  curl --data '{hero{name}}' '127.0.0.1:8000/graphql' --header "Content-Type:application/graphql"
}
}
