% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gotop.R
\name{use_gotop}
\alias{use_gotop}
\title{Add scroll up icon}
\usage{
use_gotop(
  src = "fas fa-chevron-up",
  width = 45,
  opacity = 0.5,
  place = "right",
  color = "",
  appear = 200,
  scrolltime = 800,
  fadein = 500,
  fadeout = 500,
  marginX = 2,
  marginY = 2,
  container = "",
  zIndex = 9
)
}
\arguments{
\item{src}{string The CSS classes used to display the arrow.}

\item{width}{integer The width of the arrow.}

\item{opacity}{decimal Sets the transparency level for the arrow, where 1 is not transparent at all, 0.5 is 50 percent see-through and 0 is completely transparent.}

\item{place}{string The location where the arrow will be shown. Valid values are “right” or “left”.}

\item{color}{string The color of the selected CSS classes icon.}

\item{appear}{integer The amount of pixels the page must be scrolled down before the arrow is displayed.}

\item{scrolltime}{integer A number determining how long the animation will run when scrolling to the top of the page.}

\item{fadein}{integer A number determining how long the animation will run when fading in to opaque.}

\item{fadeout}{integer A number determining how long the animation will run when fading out to transparent.}

\item{marginX}{integer The percentage amount indicating how far away the arrow is from the bottom, left, or right, depending on the value of place.}

\item{marginY}{integer The percentage amount indicating how far away the arrow is from the top or bottom, depending on the value of place.}

\item{container}{string The HTML element to which the scroll function will be attached. If no value is given, then the scroll function will be attched to the window.}

\item{zIndex}{integer The z-index value.}
}
\value{
Javascript code initializing GoTop with dependencies
}
\description{
Add scroll up icon
}
\examples{
use_gotop()

}
