% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_rename.R
\name{gs_rename}
\alias{gs_rename}
\title{Rename a spreadsheet}
\usage{
gs_rename(ss, to, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{to}{character string for new title of spreadsheet}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a \code{\link{googlesheet}} object
}
\description{
Give a spreadsheet a new name. Note that file names are not necessarily
unique within a folder on Google Drive.
}
\examples{
\dontrun{
ss <- gs_gap() \%>\% gs_copy(to = "jekyll")
gs_ls("jekyll")                  ## see? it's there
ss <- ss \%>\% gs_rename("hyde")
gs_ls("hyde")                    ## see? it's got a new name
gs_delete(ss)
}
}
