% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscriptions.R
\name{subscriptions_ack}
\alias{subscriptions_ack}
\title{Acknowledges the messages}
\usage{
subscriptions_ack(ack_ids, subscription)
}
\arguments{
\item{ack_ids}{\code{character} A vector containing one or more message ackIDs}

\item{subscription}{\code{character}, \code{Subscription} Required, the subscription whose messages
are being acknowledged}
}
\value{
\code{logical}
}
\description{
The Pub/Sub system can remove the relevant messages from the subscription.
Acknowledging a message whose ack deadline has expired may succeed, but such a message
may be redelivered later. Acknowledging a message more than once will not result in an error.
}
\seealso{
Other Subscription functions: 
\code{\link{subscriptions_create}()},
\code{\link{subscriptions_delete}()},
\code{\link{subscriptions_detach}()},
\code{\link{subscriptions_exists}()},
\code{\link{subscriptions_get}()},
\code{\link{subscriptions_list}()},
\code{\link{subscriptions_modify_ack_deadline}()},
\code{\link{subscriptions_modify_pushconf}()},
\code{\link{subscriptions_patch}()},
\code{\link{subscriptions_pull}()},
\code{\link{subscriptions_seek}()}
}
\concept{Subscription functions}
