% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudscheduler.R
\name{HttpTarget}
\alias{HttpTarget}
\title{HttpTarget Object}
\usage{
HttpTarget(
  headers = NULL,
  body = NULL,
  oauthToken = NULL,
  uri = NULL,
  oidcToken = NULL,
  httpMethod = NULL
)
}
\arguments{
\item{headers}{A named list of HTTP headers e.g. \code{list(Blah = "yes", Boo = "no")}}

\item{body}{HTTP request body.  Just send in the R object/list, which will be base64encoded correctly}

\item{oauthToken}{If specified, an OAuth token will be generated and attached as an Authorization header in the HTTP request. This type of authorization should be used when sending requests to a GCP endpoint.}

\item{uri}{Required}

\item{oidcToken}{If specified, an OIDC token will be generated and attached as an Authorization header in the HTTP request. This type of authorization should be used when sending requests to third party endpoints or Cloud Run.}

\item{httpMethod}{Which HTTP method to use for the request}
}
\value{
HttpTarget object
}
\description{
HttpTarget Object
}
\seealso{
https://cloud.google.com/scheduler/docs/reference/rest/v1/projects.locations.jobs#HttpTarget

Other Cloud Scheduler functions: 
\code{\link{Job}()},
\code{\link{cr_build_schedule_http}()},
\code{\link{cr_schedule_delete}()},
\code{\link{cr_schedule_get}()},
\code{\link{cr_schedule_list}()},
\code{\link{cr_schedule_pause}()},
\code{\link{cr_schedule_run}()},
\code{\link{cr_schedule}()}
}
\concept{Cloud Scheduler functions}
