% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga_data.R
\name{ga_data}
\alias{ga_data}
\title{Google Analytics Data for GA4 (App+Web)}
\usage{
ga_data(
  propertyId,
  metrics,
  date_range = NULL,
  dimensions = NULL,
  dim_filters = NULL,
  dimensionDelimiter = "/",
  met_filters = NULL,
  orderBys = NULL,
  limit = 100,
  page_size = 100000L,
  realtime = FALSE,
  raw_json = NULL
)
}
\arguments{
\item{propertyId}{A GA4 property Id}

\item{metrics}{The metrics to request - see \link{ga_meta} - set to NULL to only see dimensions}

\item{date_range}{A vector with start and end dates in YYYY-MM-DD format - can send in up to four date ranges at once}

\item{dimensions}{The dimensions to request - see \link{ga_meta}}

\item{dim_filters}{Filter on the dimensions of the request - a filter object created by \link{ga_data_filter}}

\item{dimensionDelimiter}{If combining dimensions in one column, the delimiter for the value field}

\item{met_filters}{Filter on the metrics of the request - a filter object created by \link{ga_data_filter}}

\item{orderBys}{How to order the response - an order object created by \link{ga_data_order}}

\item{limit}{The number of rows to return - use -1 to return all rows}

\item{page_size}{The size of API pages - default is 100000L rows}

\item{realtime}{If TRUE then will call the real-time reports, that have a more limited set of dimensions/metrics - see \href{https://developers.google.com/analytics/devguides/reporting/data/v1/realtime-basics}{valid real-time dimensions}}

\item{raw_json}{You can send in the raw JSON string for a Data API request which will skip all checks}
}
\value{
A data.frame tibble, including attributes metadata, metricAggregations and rowCount.  Use \link{ga_data_aggregations} to extract the data.frames of metricAggregations
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Fetches Google Analytics from the Data API for Google Analytics 4 (Previously App+Web)
}
\details{
This is the main function to call the Google Analytics 4 Data API.
}
\examples{

\dontrun{

# send up to 4 date ranges
multi_date <- ga_data(
  206670707,
  metrics = c("activeUsers","sessions"),
  dimensions = c("date","city","dayOfWeek"),
  date_range = c("2020-03-31", "2020-04-27", "2020-04-30", "2020-05-27"),
  dim_filters = ga_data_filter("city"=="Copenhagen"),
  limit = 100
  )


# metric and dimension expressions

# create your own named metrics
met_expression <- ga_data(
  206670707,
  metrics = c("activeUsers","sessions",sessionsPerUser = "sessions/activeUsers"),
  dimensions = c("date","city","dayOfWeek"),
  date_range = c("2020-03-31", "2020-04-27"),
  limit = 100
  )

# create your own aggregation dimensions
dim_expression <- ga_data(
  206670707,
  metrics = c("activeUsers","sessions"),
  dimensions = c("date","city","dayOfWeek", cdow = "city/dayOfWeek"),
  date_range = c("2020-03-31", "2020-04-27"),
  limit = 100
  )
  
# run a real-time report (no date dimension allowed)
realtime <- ga_data(
  206670707,
  metrics = "activeUsers",
  dimensions = c("city","unifiedScreenName"),
  limit = 100,
  realtime = TRUE)

# extract meta data from the table
ga_data_aggregations(realtime)

# add ordering
a <- ga_data_order(-sessions)
b <- ga_data_order(-dayOfWeek, type = "NUMERIC")

ga_data(
  206670707,
  metrics = c("activeUsers","sessions"),
  dimensions = c("date","city","dayOfWeek"),
  date_range = c("2020-03-31", "2020-04-27"),
  orderBys = c(a, b)
  )
}
}
\seealso{
\href{https://developers.google.com/analytics/devguides/reporting/data/v1}{Documentation on Data API}

Other GA4 functions: 
\code{\link{ga_data_filter}()},
\code{\link{ga_data_order}()}
}
\concept{GA4 functions}
