% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_dims_mets.R
\name{ga_custom_vars_create}
\alias{ga_custom_vars_create}
\title{Create a custom dimension}
\usage{
ga_custom_vars_create(
  name,
  index,
  accountId,
  webPropertyId,
  active,
  scope = c("HIT", "SESSION", "USER", "PRODUCT")
)
}
\arguments{
\item{name}{Name of custom dimension}

\item{index}{Index of custom dimension - integer between 1 and 20 (200 for GA360)}

\item{accountId}{AccountId of the custom dimension}

\item{webPropertyId}{WebPropertyId of the custom dimension}

\item{active}{\code{TRUE} or \code{FALSE} if custom dimension is active or not}

\item{scope}{Scope of custom dimension - one of \code{"HIT","SESSION","USER","PRODUCT"}}
}
\description{
Create a dimension by specifying its attributes.
}
\examples{

\dontrun{
library(googleAnalyticsR)
ga_auth()

# create custom var
ga_custom_vars_create("my_custom_dim",
                      index = 15,
                      accountId = 54019251,
                      webPropertyId = "UA-54019251-4",
                      scope = "HIT",
                      active = FALSE)

# view custom dimension in list
ga_custom_vars_list(54019251, webPropertyId = "UA-54019251-4", type = "customDimensions")

}
}
\seealso{
\href{https://support.google.com/analytics/answer/2709828}{Custom dimensions support article}

Other custom variable functions: 
\code{\link{ga_custom_vars_list}()},
\code{\link{ga_custom_vars_patch}()},
\code{\link{ga_custom_vars}()}
}
\concept{custom variable functions}
