##
## cvmtest.R
##
## Cramer-von Mises test
##
## $Revision: 1.2 $ $Date: 2014/06/08 11:32:51 $
##

cvm.test <- function(x, null="punif", ..., nullname) {
  xname <- deparse(substitute(x))
  nulltext <- deparse(substitute(null))
  if(is.character(null)) nulltext <- null
  if(missing(nullname))
    nullname <- if(identical(null, "punif")) "uniform distribution" else
                paste("distribution", sQuote(nulltext))
  stopifnot(is.numeric(x))
  x <- as.vector(x)
  n <- length(x)
  F0 <- if(is.function(null)) null else
        if(is.character(null)) get(null, mode="function") else
        stop("Argument 'null' should be a function, or the name of a function")
  U <- F0(x, ...)
  if(any(U < 0 | U > 1))
    stop("null distribution function returned values outside [0,1]")
  U <- sort(U)
  k <- seq_len(n)
  omega2 <- 1/(12 * n) + sum((U - (2*k - 1)/(2*n))^2)
  PVAL <- pCvM(omega2, n=n, lower.tail=FALSE)
  names(omega2) <- "omega2"
  METHOD <- paste("Cramer-von Mises test of", nullname)
  ALTERN <- paste("Not the", nullname)
  out <- list(statistic = omega2,
               p.value = PVAL,
               alternative = ALTERN,
               method = METHOD,
               data.name = xname)
  class(out) <- "htest"
  return(out)
}

