% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmwmx2.R
\name{gmwmx2}
\alias{gmwmx2}
\title{Estimate a trajectory model for a \code{gnss_ts_ngl} object considering a white noise plus colored noise as the stochastic model for the residuals and model missingness with a Markov process using the GMWMX estimator.}
\usage{
gmwmx2(
  x,
  n_seasonal = 2,
  vec_earthquakes_relaxation_time = NULL,
  component = "N",
  toeplitz_approx_var_cov_wv = TRUE,
  stochastic_model = "wn + fl"
)
}
\arguments{
\item{x}{A \code{gnss_ts_ngl} object.}

\item{n_seasonal}{An \code{integer} specifying the number of seasonal signals in the time series. "1" specify only one annual periodic signal and "2"specify an annual and a semiannual periodic signal.}

\item{vec_earthquakes_relaxation_time}{A \code{vector} specifying the relaxation time for each earthquakes indicated for the time series.}

\item{component}{A \code{string} with value either "N", "E" or "V" that specify which component to estimate (Northing, Easting or Vertical).}

\item{toeplitz_approx_var_cov_wv}{A \code{boolean} that specify if the variance of the wavelet variance should be computed based on a toeplitz approximation of the variance covariance matrix of the residuals.}

\item{stochastic_model}{A \code{string} that specify the stochastic model considered for the residuals. Either "wn + fl" for white noise and flicker/pink noise or "wn + pl" for white noise and stationary power-law noise.}
}
\description{
Estimate a trajectory model for a \code{gnss_ts_ngl} object considering a white noise plus colored noise as the stochastic model for the residuals and model missingness with a Markov process using the GMWMX estimator.
}
\examples{
x <- download_station_ngl("CHML")
fit <- gmwmx2(x, n_seasonal = 2, component = "N")
}
