% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMWM.R
\name{update.gmwm}
\alias{update.gmwm}
\title{Update GMWM object for sensor, ARMA, SSM, and Robust}
\usage{
\method{update}{gmwm}(object, model, ...)
}
\arguments{
\item{object}{A \code{gmwm} object.}

\item{model}{A \code{ts.model} object containing one of the allowed models}

\item{...}{Additional parameters (not used)}
}
\value{
A \code{gmwm} object that contains:
\itemize{
 \item{}
 \item{}
 \item{}
}
}
\description{
GMM object
}
\details{
This function is under work. Some of the features are active. Others... Not so much.
}
\examples{
# AR
set.seed(1336)
n = 200
exact.model = AR1(phi=.99, sigma2 = 0.01) + WN(sigma2=1)
data = gen.gts(exact.model)

# Create an initial model that is not accurate
bad.model = gmwm(AR1(), data = data)

# Models can contain specific parameters e.g.
updated.model = update(bad.model, exact.model)

# Or...
updated.model.guided = update(bad.model, AR1()+AR1())
}

