% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_methods.R
\name{rank.models}
\alias{rank.models}
\title{Automatically select appropriate model for a set of models}
\usage{
rank.models(data, models = list(AR1() + WN(), AR1()), nested = F,
  bootstrap = F, model.type = "ssm", alpha = 0.05, robust = F,
  eff = 0.6, B = 50, G = 1e+05, seed = 1337)
}
\arguments{
\item{data}{A \code{vector}, \code{data.frame}, \code{matrix}, or \code{gts} object with 1 column.}

\item{models}{A list of \code{ts.model} objects.}

\item{nested}{A \code{bool} that indicates whether the ts.model objects are nested within a large object given within the list. If not, the a full model will be created.}

\item{bootstrap}{A \code{bool} that is either true or false to indicate whether we use bootstrap or asymptotic By default, we use asymptotic.}

\item{model.type}{A \code{string} indicating whether the model should be a \code{"ssm"} or \code{"imu"}.}

\item{alpha}{A \code{double} that indicates the level of confidence for the WV CI.}

\item{robust}{A \code{boolean} that indicates whether to use robust estimation.}

\item{eff}{A \code{double} between 0 and 1 that indicates the efficiency for the robust estimation.}

\item{B}{A \code{integer} that contains the amount of bootstrap replications}

\item{G}{A \code{integer} that indicates the amount of guesses for caliberating the startup.}

\item{seed}{A \code{integer} that is used to set a seed for reproducibility.}
}
\value{
A \code{rank.models} object.
}
\description{
Runs through a model selection algorithm to determine the best model in a given set
}
\details{
The models MUST be nested within each other. If the models are not nested, the algorithm creates the "common denominator" model.
}

