% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{get_alpha_mt}
\alias{get_alpha_mt}
\title{Get mixing weights alpha_mt (this function is for internal use)}
\usage{
get_alpha_mt(M, log_mvdvalues, alphas, epsilon, conditional, also_l_0 = FALSE)
}
\arguments{
\item{M}{\describe{
  \item{For \strong{GMVAR} and \strong{StMVAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMVAR} models:}{a size (2x1) integer vector specifying the number of \emph{GMVAR type} components \code{M1}
   in the first element and \emph{StMVAR type} components \code{M2} in the second element. The total number of mixture components
   is \code{M=M1+M2}.}
}}

\item{log_mvdvalues}{\eqn{T x M} matrix containing the log multivariate normal densities.}

\item{alphas}{\eqn{M x 1} vector containing the mixing weight pa}

\item{epsilon}{the smallest number such that its exponent is wont classified as numerically zero
(around \code{-698} is used).}

\item{conditional}{a logical argument specifying whether the conditional or exact log-likelihood function
should be used.}

\item{also_l_0}{return also l_0 (the first term in the exact log-likelihood function)?}
}
\value{
Returns the mixing weights a matrix of the same dimension as \code{log_mvdvalues} so
  that the t:th row is for the time point t and m:th column is for the regime m.
}
\description{
\code{get_alpha_mt} computes the mixing weights based on
  the logarithm of the multivariate normal densities in the definition of
  the mixing weights.
}
\details{
Note that we index the time series as \eqn{-p+1,...,0,1,...,T} as in Kalliovirta et al. (2016).
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. (forthcoming). A statistically identified structural vector autoregression with endogenously
          switching volatility regime. \emph{Journal of Business & Economic Statistics}.
   \item Virolainen S. 2022. Gaussian and Student's t mixture vector autoregressive model with application to the
     asymmetric effects of monetary policy shocks in the Euro area. Unpublished working
     paper, available as arXiv:2109.13648.
 }
 @keywords internal
}
\seealso{
\code{\link{loglikelihood_int}}
}
\keyword{internal}
