% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcal.R
\name{diag_Omegas}
\alias{diag_Omegas}
\title{Simultaneously diagonalize two covariance matrices}
\usage{
diag_Omegas(Omega1, Omega2)
}
\arguments{
\item{Omega1}{a positive definite \eqn{(dxd)} covariance matrix \eqn{(d>1)}}

\item{Omega2}{another positive definite \eqn{(dxd)} covariance matrix}
}
\value{
Returns a length \eqn{d^2 + d} vector where the first \eqn{d^2} elements
  are \eqn{vec(W)} with the columns of \eqn{W} being (specific) eigenvectors of
  the matrix \eqn{\Omega_2\Omega_1^{-1}} and the rest \eqn{d} elements are the
  corresponding eigenvalues "lambdas". The result satisfies \eqn{WW' = Omega1} and
  \eqn{Wdiag(lambdas)W' = Omega2}.

  If \code{Omega2} is not supplied, returns a vectorized symmetric (and pos. def.)
  square root matrix of \code{Omega1}.
}
\description{
\code{diag_Omegas} Simultaneously diagonalizes two covariance matrices using
  eigenvalue decomposition.
}
\details{
See the return value and Muirhead (1982), Theorem A9.9 for details.
}
\section{Warning}{

 No argument checks! Does not work with dimension \eqn{d=1}!
}

\examples{
d <- 2
W0 <- matrix(1:(d^2), nrow=2)
lambdas0 <- 1:d
(Omg1 <- W0\%*\%t(W0))
(Omg2 <- W0\%*\%diag(lambdas0)\%*\%t(W0))
res <- diag_Omegas(Omg1, Omg2)
W <- matrix(res[1:(d^2)], nrow=d, byrow=FALSE)
tcrossprod(W) # == Omg1
lambdas <- res[(d^2 + 1):(d^2 + d)]
W\%*\%diag(lambdas)\%*\%t(W) # == Omg2
}
\references{
\itemize{
  \item Muirhead R.J. 1982. Aspects of Multivariate Statistical Theory, \emph{Wiley}.
}
}
