% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateParams.R
\name{smart_ind}
\alias{smart_ind}
\title{Create random parameter vector of a GMVAR model fairly close to a given
  parameter vector}
\usage{
smart_ind(
  p,
  M,
  d,
  params,
  constraints = NULL,
  same_means = NULL,
  structural_pars = NULL,
  accuracy = 1,
  which_random = numeric(0),
  mu_scale,
  mu_scale2,
  omega_scale,
  ar_scale = 1,
  ar_scale2 = 1,
  W_scale,
  lambda_scale
)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{d}{the number of time series in the system.}

\item{params}{a real valued vector specifying the parameter values.
  \describe{
    \item{\strong{For reduced form model:}}{
      Should be size
      \eqn{((M(pd^2+d+d(d+1)/2+1)-1)x1)} and have form \strong{\eqn{\theta}}\eqn{ = }(\strong{\eqn{\upsilon}}\eqn{_{1}},
      ...,\strong{\eqn{\upsilon}}\eqn{_{M}}, \eqn{\alpha_{1},...,\alpha_{M-1}}), where:
      \itemize{
        \item \strong{\eqn{\upsilon}}\eqn{_{m}} \eqn{ = (\phi_{m,0},}\strong{\eqn{\phi}}\eqn{_{m}}\eqn{,\sigma_{m})}
        \item \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p})}
        \item and \eqn{\sigma_{m} = vech(\Omega_{m})}, m=1,...,M.
      }
    }
    \item{\strong{For structural GMVAR model:}}{
      Should have the form
      \strong{\eqn{\theta}}\eqn{ = (\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{_{1},...,}\strong{\eqn{\phi}}\eqn{_{M},
      vec(W),}\strong{\eqn{\lambda}}\eqn{_{2},...,}\strong{\eqn{\lambda}}\eqn{_{M},\alpha_{1},...,\alpha_{M-1})}, where
      \itemize{
        \item\strong{\eqn{\lambda}}\eqn{_{m}=(\lambda_{m1},...,\lambda_{md})} contains the eigenvalues of the \eqn{m}th mixture component.
      }
    }
  }
  Above, \eqn{\phi_{m,0}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}:th coefficient matrix of
  the \eqn{m}:th mixture component, \eqn{\Omega_{m}} denotes the error term covariance matrix of the \eqn{m}:th
  mixture component, and \eqn{\alpha_{m}} is the mixing weight parameter. The \eqn{W} and \eqn{\lambda_{mi}} are
  structural parameters replacing the error term covariance matrices (see Virolainen, 2020). If \eqn{M=1}, \eqn{\alpha_{m}}
  and \eqn{\lambda_{mi}} are dropped.

  If \code{parametrization=="mean"}, just replace each \eqn{\phi_{m,0}} with the regimewise mean \eqn{\mu_{m}}.
  \eqn{vec()} is vectorization operator that stacks columns of a given matrix into a vector. \eqn{vech()} stacks columns
  of a given matrix from the principal diagonal downwards (including elements on the diagonal) into a vector.
  The notation is in line with the cited article by KMS (2016) introducing the GMVAR model.}

\item{constraints}{a size \eqn{(Mpd^2 x q)} constraint matrix \strong{\eqn{C}} specifying general linear constraints
to the autoregressive parameters. We consider constraints of form
(\strong{\eqn{\phi}}\eqn{_{1}}\eqn{,...,}\strong{\eqn{\phi}}\eqn{_{M}) = }\strong{\eqn{C \psi}},
where \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p}) (pd^2 x 1), m=1,...,M},
contains the coefficient matrices and \strong{\eqn{\psi}} \eqn{(q x 1)} contains the related parameters.
For example, to restrict the AR-parameters to be the same for all regimes, set \strong{\eqn{C}}=
[\code{I:...:I}]\strong{'} \eqn{(Mpd^2 x pd^2)} where \code{I = diag(p*d^2)}.
Ignore (or set to \code{NULL}) if linear constraints should \strong{not} be employed.}

\item{same_means}{Restrict the mean parameters of some regimes to be the same? Provide a list of numeric vectors
such that each numeric vector contains the regimes that should share the common mean parameters. For instance, if
\code{M=3}, the argument \code{list(1, 2:3)} restricts the mean parameters of the second and third regime to be
the same but the first regime has freely estimated (unconditional) mean. Ignore or set to \code{NULL} if mean parameters
should not be restricted to be the same among any regimes. \strong{This constraint is available only for mean parametrized models;
that is, when \code{parametrization="mean"}.}}

\item{structural_pars}{If \code{NULL} a reduced form model is considered. For structural model, should be a list containing
the following elements:
\itemize{
  \item \code{W} - a \eqn{(dxd)} matrix with its entries imposing constraints on \eqn{W}: \code{NA} indicating that the element is
    unconstrained, a positive value indicating strict positive sign constraint, a negative value indicating strict
    negative sign constraint, and zero indicating that the element is constrained to zero.
  \item \code{C_lambda} - a \eqn{(d(M-1) x r)} constraint matrix that satisfies (\strong{\eqn{\lambda}}\eqn{_{2}}\eqn{,...,}
    \strong{\eqn{\lambda}}\eqn{_{M}) =} \strong{\eqn{C_{\lambda} \gamma}} where \strong{\eqn{\gamma}} is the new \eqn{(r x 1)}
    parameter subject to which the model is estimated (similarly to AR parameter constraints). The entries of \code{C_lambda}
    must be either \strong{positive} or \strong{zero}. Ignore (or set to \code{NULL}) if the eigenvalues \eqn{\lambda_{mi}}
    should not be constrained.
}
See Virolainen (2020) for the conditions required to identify the shocks and for the B-matrix as well (it is \eqn{W} times
a time-varying diagonal matrix with positive diagonal entries).}

\item{accuracy}{a positive real number adjusting how close to the given parameter vector the returned individual should be.
Larger number means larger accuracy. Read the source code for details.}

\item{which_random}{a vector with length between 1 and M specifying the mixture components that should be random instead of
close to the given parameter vector. This does not consider constrained AR or lambda parameters.}

\item{mu_scale}{a size \eqn{(dx1)} vector defining \strong{means} of the normal distributions from which each
mean parameter \eqn{\mu_{m}} is drawn from in random mutations. Default is \code{colMeans(data)}. Note that
mean-parametrization is always used for optimization in \code{GAfit} - even when \code{parametrization=="intercept"}.
However, input (in \code{initpop}) and output (return value) parameter vectors can be intercept-parametrized.}

\item{mu_scale2}{a size \eqn{(dx1)} strictly positive vector defining \strong{standard deviations} of the normal
distributions from which each mean parameter \eqn{\mu_{m}} is drawn from in random mutations.
Default is \code{2*sd(data[,i]), i=1,..,d}.}

\item{omega_scale}{a size \eqn{(dx1)} strictly positive vector specifying the scale and variability of the
random covariance matrices in random mutations. The covariance matrices are drawn from (scaled) Wishart
distribution. Expected values of the random covariance matrices are \code{diag(omega_scale)}. Standard
deviations of the diagonal elements are \code{sqrt(2/d)*omega_scale[i]}
and for non-diagonal elements they are \code{sqrt(1/d*omega_scale[i]*omega_scale[j])}.
Note that for \code{d>4} this scale may need to be chosen carefully. Default in \code{GAfit} is
\code{var(stats::ar(data[,i], order.max=10)$resid, na.rm=TRUE), i=1,...,d}. This argument is ignored if
structural model is considered.}

\item{ar_scale}{a positive real number adjusting how large AR parameter values are typically proposed in construction
of the initial population: larger value implies larger coefficients (in absolute value). After construction of the
initial population, a new scale is drawn from \code{(0, 0.)} uniform distribution in each iteration.}

\item{ar_scale2}{a positive real number adjusting how large AR parameter values are typically proposed in some
random mutations (if AR constraints are employed, in all random mutations): larger value implies \strong{smaller} coefficients
(in absolute value). \strong{Values larger than 1 can be used if the AR coefficients are expected to be very small.
If set smaller than 1, be careful as it might lead to failure in the creation of stationary parameter candidates}}

\item{W_scale}{a size \eqn{(dx1)} strictly positive vector partly specifying the scale and variability of the
random covariance matrices in random mutations. The elements of the matrix \eqn{W} are drawn independently
from such normal distributions that the expectation of the main \strong{diagonal} elements of the first
regime's error term covariance matrix \eqn{\Omega_1 = WW'} is \code{W_scale}. The distribution of \eqn{\Omega_1}
will be in some sense like a Wishart distribution but with the columns (elements) of \eqn{W} obeying the given
constraints. The constraints are accounted for by setting the element to be always zero if it is subject to a zero
constraint and for sign constraints the absolute value or negative the absolute value are taken, and then the
variances of the elements of \eqn{W} are adjusted accordingly. This argument is ignored if reduced form model
is considered.}

\item{lambda_scale}{a length \eqn{M - 1} vector specifying the \strong{standard deviation} of the mean zero normal
  distribution from which the eigenvalue \eqn{\lambda_{mi}} parameters are drawn from in random mutations.
  As the eigenvalues should always be positive, the absolute value is taken. The elements of \code{lambda_scale}
  should be strictly positive real numbers with the \eqn{m-1}th element giving the degrees of freedom for the \eqn{m}th
  regime. The expected value of the main \strong{diagonal} elements \eqn{ij} of the \eqn{m}th \eqn{(m>1)} error term covariance
  matrix will be \code{W_scale[i]*(d - n_i)^(-1)*sum(lambdas*ind_fun)} where the \eqn{(d x 1)} vector \code{lambdas} is
  drawn from the absolute value of the t-distribution, \code{n_i} is the number of zero constraints in the \eqn{i}th
  row of \eqn{W} and \code{ind_fun} is an indicator function that takes the value one iff the \eqn{ij}th element of
  \eqn{W} is not constrained to zero. Basically, larger lambdas (or smaller degrees of freedom) imply larger variance.

  If the lambda parameters are \strong{constrained} with the \eqn{(d(M - 1) x r)} constraint matrix \eqn{C_lambda},
  then provide a length \eqn{r} vector specifying the standard deviation of the (absolute value of the) mean zero
  normal distribution each of the \eqn{\gamma} parameters are drawn from (the \eqn{\gamma} is a \eqn{(r x 1)} vector).
  The expected value of the main diagonal elements of the covariance matrices then depend on the constraints.

  This argument is ignored if \eqn{M==1} or a reduced form model is considered. Default is \code{rep(3, times=M-1)}
  if lambdas are not constrained and \code{rep(3, times=r)} if lambdas are constrained.

  As with omega_scale and W_scale, this argument should be adjusted carefully if specified by hand. \strong{NOTE}
  that if lambdas are constrained in some other way than restricting some of them to be identical, this parameter
  should be adjusted accordingly in order to the estimation succeed!}
}
\value{
Returns random mean-parametrized parameter vector that has the same form as the argument \code{params}
  in the other functions, for instance, in the function \code{loglikelihood}.
}
\description{
\code{smart_ind} creates random mean-parametrized parameter vector of a GMVAR model fairly
 close to a given parameter vector. The result may not be stationary.
}
\section{Warning}{

  No argument checks!
}

\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
 @keywords internal
}
\keyword{internal}
