% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.R
\name{logLik}
\alias{logLik}
\alias{logLik.gmm}
\alias{logLik.gmbn}
\alias{logLik.gmdbn}
\title{Compute the log-likelihood of a Gaussian mixture model or graphical model}
\usage{
\method{logLik}{gmm}(object, data, y = NULL, regul = NULL, ...)

\method{logLik}{gmbn}(object, data, col_seq = NULL, ...)

\method{logLik}{gmdbn}(object, data, col_seq = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{gmm}, \code{gmbn} or \code{gmdbn}.}

\item{data}{A data frame containing the data used to compute the
log-likelihood. Its columns must explicitly be named after the variables (or
nodes) of \code{object}. If \code{object} is a \code{gmm} object, a numeric
matrix can be passed.}

\item{y}{A character vector containing the dependent variables if a
conditional log-likelihood is computed. If \code{NULL} (the default), the
joint log-likelihood is computed.}

\item{regul}{A positive numeric value corresponding to the regularization
constant if a penalty term is added for Bayesian regularization. If
\code{NULL} (the default) no penalty term is added. If a conditional
log-likelihood is computed, this argument is ignored.}

\item{\dots}{Unused arguments from the generic function.}

\item{col_seq}{A character vector containing the column names of \code{data}
that describe the observation sequence. If \code{NULL} (the default), all the
observations belong to a single sequence. If \code{object} is a temporal
\code{gmbn} or \code{gmdbn} object, the observations of a same sequence must
be ordered such that the \eqn{t}th one is related to time slice \eqn{t}
(note that the sequences can have different lengths). If \code{object} is a
non-temporal \code{gmbn} object, this argument is ignored.}
}
\value{
If \code{object} is a \code{gmm} object, a numeric value
corresponding to the log-likelihood.

If \code{object} is a \code{gmbn} or \code{gmdbn} object, a list with
elements:
\item{global}{A numeric value corresponding to the global log-likelihood.}
\item{local}{For a \code{gmbn} object, a numeric vector containing the local
conditional log-likelihoods. For a \code{gmdbn} object, a list of numeric
vectors containing these values for each \code{gmbn} element.}
}
\description{
This function computes the log-likelihood of a Gaussian mixture model or
graphical model.
}
\examples{
data(gmm_body, data_body)
loglik_1 <- logLik(gmm_body, data_body)
loglik_2 <- logLik(gmm_body, data_body, y = "WAIST")

data(gmbn_body, data_body)
loglik_3 <- logLik(gmbn_body, data_body)

data(gmdbn_air, data_air)
loglik_4 <- logLik(gmdbn_air, data_air, col_seq = "DATE")

}
\seealso{
\code{\link{AIC}}, \code{\link{BIC}}
}
