% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message.R
\name{save_attachments}
\alias{save_attachments}
\title{Save attachments to a message}
\usage{
save_attachments(x, attachment_id = NULL, path = ".", user_id = "me")
}
\arguments{
\item{x}{message with attachment}

\item{attachment_id}{id of the attachment to save, if none specified saves all attachments}

\item{path}{where to save the attachments}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Function to retrieve and save all of the attachments to a message by id of the message.
}
\examples{
\dontrun{
# save all attachments
save_attachments(my_message)
# save a specific attachment
save_attachments(my_message, 'a32e324b')
}
}
\references{
\url{https://developers.google.com/gmail/api/v1/reference/users/messages/attachments/get}
}
\seealso{
Other message: \code{\link{attachment}},
  \code{\link{delete_message}},
  \code{\link{import_message}},
  \code{\link{insert_message}}, \code{\link{messages}},
  \code{\link{message}}, \code{\link{modify_message}},
  \code{\link{save_attachment}},
  \code{\link{send_message}}, \code{\link{trash_message}},
  \code{\link{untrash_message}}
}

