% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{gsi.EVario2D}
\alias{gsi.EVario2D}
\title{Empirical variogram or covariance function in 2D}
\usage{
gsi.EVario2D(
  X,
  Z,
  Ff = rep(1, nrow(X)),
  maxdist = max(dist(X[sample(nrow(X), min(nrow(X), 1000)), ]))/2,
  lagNr = 15,
  lags = seq(from = 0, to = maxdist, length.out = lagNr + 1),
  azimuthNr = 4,
  azimuths = seq(from = 0, to = 180, length.out = azimuthNr + 1)[1:azimuthNr],
  maxbreadth = Inf,
  minpairs = 10,
  cov = FALSE
)
}
\arguments{
\item{X}{matrix of Nx2 columns with the geographic coordinates}

\item{Z}{matrix or data.frame of data with dimension (N,Dv)}

\item{Ff}{for variogram, matrix of basis functions with nrow(Ff)=N (can be a N-vector of 1s);
for covariance function, a (N,Dv)-matrix or a  Dv-vector giving the mean values}

\item{maxdist}{maximum lag distance to consider}

\item{lagNr}{number of lags to consider}

\item{lags}{if maxdist and lagNr are not specified, either: (a) a matrix of 2 columns giving
minimal and maximal lag distance defining the lag classes to consider, or (b) a vector of lag breaks}

\item{azimuthNr}{number of azimuths to consider}

\item{azimuths}{if azimuthNr is not specified, either: (a) a matrix of 2 columns giving
minimal and maximal azimuth defining the azimuth classes to consider, or (b) a vector of azimuth breaks}

\item{maxbreadth}{maximal breadth (in lag units) orthogonal to the lag direction}

\item{minpairs}{minimal number of pairs falling in each class to consider the calculation sufficient; defaults to 10}

\item{cov}{boolean, is covariance (TRUE) or variogram (FALSE) desired? defaults to variogram}
}
\value{
An empirical variogram for the provided data. NOTE: avoid using directly gsi.* functions! They
represent either internal functions, or preliminary, not fully-tested functions. Use \code{\link{variogram}} instead.
}
\description{
compute the empirical variogram or covariance function in a 2D case study
}
\examples{
library(gstat)
data("jura", package = "gstat")
X = as.matrix(jura.pred[,1:2])
Z = as.matrix(jura.pred[,c("Zn","Cd","Pb")])
vge = gsi.EVario2D(X,Z)
dim(vge)
dimnames(vge)
class(vge["gamma",1])
dim(vge["gamma",1][[1]])
vge["npairs",1]
vge["lags",1]
}
\seealso{
Other gmEVario functions: 
\code{\link{as.gmEVario}()},
\code{\link{ndirections}()},
\code{\link{plot.gmEVario}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmEVario functions}
