% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glyco.plot.R
\name{glyco.plot}
\alias{glyco.plot}
\title{Plot data representing Glycans in boxplot or violin mode using ggplot2}
\usage{
glyco.plot(data, collapse = TRUE, violin = FALSE, group = NULL,
  all = TRUE, p.adjust.method = "holm", print.p.values = TRUE,
  log.transform = FALSE, glyco.names = NULL)
}
\arguments{
\item{data}{data frame which holds columns representing Glycans.
These column names must start with 'GP'.}

\item{collapse}{should Glycans be presented in one facet (default)
or with more facets (one per Glycan).}

\item{violin}{should Glycans be presented in a boxplot (default)
or violin format.}

\item{group}{this a possible grouping parameter on which
stratification of \code{data} should be conducted. It should be
a name of one of the columns in dataframe \code{data}
and of type \code{factor}.}

\item{all}{should all of the variables (default) be presented in the plot
or only those that have significant p-values. This variable is
meaningful only when \code{group} is not \code{NULL} since the testing
of differences is conducted  between different groups represented
by \code{group} variable. If \code{group} has only 2 levels then
Mann-Whitney-Wilcoxon (\code{\link{wilcox.test}}) test is conducted.
Otherwise, Kruskal-Wallis test is conducted (\code{\link{kruskal.test}}).
Obtained p-values are adjusted to multiple testing with \code{\link{p.adjust}}.}

\item{p.adjust.method}{method used for adjustment of p-values to multiple
testing. Variable p.adjust.method must be an element of
\code{\link{p.adjust.methods}}.}

\item{print.p.values}{should p-values be printed on plots}

\item{log.transform}{should Glycans be log transform prior to plotting.}

\item{glyco.names}{names of columns that represent glycan data. If \code{NULL}
all columns starting with 'GP' in their names will be used}
}
\value{
Returns a list consisting of p-values, adjusted p-vales and the plot.
}
\description{
This function constructs standard plots in exploratory analysis 
of N-Glycans.
}
\examples{
devAskNewPage(TRUE)
exampleData <- data.frame(ID=1:100, GP1=runif(100),
  GP2=rexp(100,0.2), GP3=rgamma(100, 3),
  Plate=factor(sample(1:2,100,replace=TRUE)))
glyco.plot(exampleData)
glyco.plot(exampleData, group='Plate', collapse=FALSE, log=TRUE)
}
\author{
Ivo Ugrina
}
