% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.perf.glmnetr_240226.R
\name{plot_perf_glmnetr}
\alias{plot_perf_glmnetr}
\title{Plot nested cross validation fit summaries}
\usage{
plot_perf_glmnetr(
  x,
  type = "agree",
  pow = 2,
  ylim = 1,
  fold = 1,
  pch = 20,
  plot = 1
)
}
\arguments{
\item{x}{A nested.glmnetr output object}

\item{type}{determines what type of nested cross validation performance measures are 
plotted.  Possible values are "agree" to plot agreement, "lincal" to plot the linear
calibration slope coefficients, "intcal" to plot the linear calibration intercept 
coefficients or "devrat" to plot the model reduction in deviances relative to 
the null model deviances, from the nested cross 
validation.}

\item{pow}{Power to which agreement is to be raised when the "gaussian" model 
is fit, i.e. 2 for R-square, 1 for correlation.  Does not apply to type = "lasso".}

\item{ylim}{y axis limits for model perforamnce plots, i.e. does not apply to 
type = "lasso".  The ridge model may calibrate very poorly obscuring plots for 
type of "lincal" or "intcal", so one may specify the ylim value.  If ylim is 
set to 1, then the program will derive a reasonable range for ylim.  If ylim is 
set to 0, then the entire range for all models will be displayed.  Does not 
apply to type = "lasso".}

\item{fold}{By default 1 to display using a spaghetti the performance as 
calculated from the individual folds, 0 to display using dots only the composite 
values calculated using all folds.}

\item{pch}{A number indicating which symbol is to be used in place of the lines 
when fold=0.}

\item{plot}{By default 1 to produce a plot, 0 to return the data used in the 
plot in the form of a list.}
}
\value{
This program returns a plot to the graphics window by default, and returns
a list with data used in teh plots if the plot=1 is specified.
}
\description{
This function plots summary information from a nested.glmnetr() output object, that 
is from a nested cross validation performance.  Alternamvely one can output the 
numbers otherwise displayed to a list for extration or customized plotting. Performance
mesures for plotting include "agree" a measure of agreement, "lincal" the slope 
from a linear calibration, "intcal" the intercept from a lienar calibration, 
and "devrat" the deviance ratio, i.e. the fractional reduction in deviances 
relative compared to the null model deviances, Performance measure estimates 
from the individual (outer) cross validation fold are depicted by thin lines 
of different colors and styles, while the composite value from all folds is 
depicted by a thicker black line, and the performance measures naively 
calculated on the all data using the model derived from all data is 
depicted by a thicker red line.
}
\seealso{
\code{\link{plot.glmnetr}} , \code{\link{plot.cv.glmnetr}} , \code{\link{plot.nested.glmnetr}}
}
\author{
Walter Kremers (kremers.walter@mayo.edu)
}
