% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.glmmTMB}
\alias{confint.glmmTMB}
\title{Calculate confidence intervals}
\usage{
\method{confint}{glmmTMB}(object, parm, level = 0.95, method = c("wald",
  "Wald", "profile", "uniroot"), component = c("all", "cond", "zi", "other"),
  estimate = TRUE, parallel = c("no", "multicore", "snow"),
  ncpus = getOption("profile.ncpus", 1L), cl = NULL, ...)
}
\arguments{
\item{object}{\code{glmmTMB} fitted object.}

\item{parm}{Specification of a parameter subset \emph{after}
\code{component} subset has been applied.}

\item{level}{Confidence level.}

\item{method}{'wald', 'profile', or 'uniroot': see Details
function)}

\item{component}{Which of the three components 'cond', 'zi' or
'other' to select. Default is to select 'all'.}

\item{estimate}{(logical) add a third column with estimate ?}

\item{parallel}{method (if any) for parallel computation}

\item{ncpus}{number of CPUs/cores to use for parallel computation}

\item{cl}{cluster to use for parallel computation}

\item{...}{arguments may be passed to \code{\link{profile.merMod}} or
\code{\link{tmbroot}}}
}
\description{
Calculate confidence intervals
}
\details{
Available methods are
\describe{
\item{wald}{These intervals are based on the standard errors
calculated for parameters on the scale
of their internal parameterization depending on the family. Derived
quantities such as standard deviation parameters and dispersion
parameters are backtransformed. It follows that confidence
intervals for these derived quantities are asymmetric.}
\item{profile}{This method computes a likelihood profile
for the specified parameter(s) using \code{profile.glmmTMB};
fits a spline function to each half of the profile; and
inverts the function to find the specified confidence interval.}
\item{uniroot}{This method uses the \code{\link{uniroot}}
function to find critical values of one-dimensional profile
functions for each specified parameter.}
}
}
\examples{
data(sleepstudy, package="lme4")
model <- glmmTMB(Reaction ~ Days + (1|Subject), sleepstudy)
confint(model)
\dontrun{
confint(model,parm=1,method="profile")
}
}
