% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmmSeq.R
\name{lmmSeq}
\alias{lmmSeq}
\title{Linear mixed models for data matrix}
\usage{
lmmSeq(
  modelFormula,
  maindata,
  metadata,
  id,
  sizeFactors = NULL,
  reducedFormula = "",
  modelData = NULL,
  designMatrix = NULL,
  control = lmerControl(),
  cores = 1,
  removeDuplicatedMeasures = FALSE,
  removeSingles = FALSE,
  verbose = TRUE,
  returnList = FALSE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{modelFormula}{the model formula. This must be of the form \code{"~ ..."}
where the structure is assumed to be \code{"gene ~ ..."}. The formula must
include a random effects term. For more information on formula structure
for random effects see \code{\link[lme4:lmer]{lme4::lmer()}}}

\item{maindata}{data matrix with genes in rows and samples in columns}

\item{metadata}{a dataframe of sample information with variables in columns
and samples in rows}

\item{id}{Column name in metadata which contains the sample IDs to be used
in pairing samples}

\item{sizeFactors}{size factors (default = NULL). If provided the glmer
offset is set to log(sizeFactors). For more information see
\code{\link[lme4:glmer]{lme4::glmer()}}}

\item{reducedFormula}{Reduced design formula (default = "")}

\item{modelData}{Expanded design matrix}

\item{designMatrix}{custom design matrix}

\item{control}{the glmer control (default = glmerControl(optimizer =
"bobyqa")). For more information see
\code{\link[lme4:glmerControl]{lme4::glmerControl()}}.}

\item{cores}{number of cores to use. Default = 1.}

\item{removeDuplicatedMeasures}{whether to remove duplicated
conditions/repeated measurements for a given time point (default = FALSE).}

\item{removeSingles}{whether to remove individuals with only one measurement
(default = FALSE)}

\item{verbose}{Logical whether to display messaging (default = TRUE)}

\item{returnList}{Logical whether to return results as a list or lmmSeq
object (default = FALSE).}

\item{progress}{Logical whether to display a progress bar}

\item{...}{Other parameters to pass to
\code{\link[lme4:glmer]{lme4::glmer()}}}
}
\value{
Returns an S4 class \code{lmmSeq} object with results for gene-wise
general linear mixed models or a list of results if \code{returnList} is \code{TRUE}.
}
\description{
Linear mixed models for data matrix
}
\examples{
data(PEAC_minimal_load)
logtpm <- log2(tpm +1)
lmmtest <- lmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                     id = "PATID",
                     maindata = logtpm["MS4A1", ],
                     metadata = metadata,
                     verbose = FALSE)
names(attributes(lmmtest))
}
