% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot.glmdisc}
\alias{plot,glmdisc,ANY-method}
\alias{plot,glmdisc,missing-method}
\title{Plots for the discretized / grouped data.}
\usage{
plot.glmdisc(x)
}
\arguments{
\item{x}{The S4 \code{\link{glmdisc}} object to plot.}
}
\description{
This defines the \code{\link{plot}} method which will plot some useful graphs for the discretization scheme of S4 class \code{\link{glmdisc}}
}
\examples{
# Simulation of a discretized logit model
set.seed(1)
x = matrix(runif(300), nrow = 100, ncol = 3)
cuts = seq(0,1,length.out= 4)
xd = apply(x,2, function(col) as.numeric(cut(col,cuts)))
theta = t(matrix(c(0,0,0,2,2,2,-2,-2,-2),ncol=3,nrow=3))
log_odd = rowSums(t(sapply(seq_along(xd[,1]), function(row_id) sapply(seq_along(xd[row_id,]),
function(element) theta[xd[row_id,element],element]))))
y = rbinom(100,1,1/(1+exp(-log_odd)))

sem_disc <- glmdisc(x,y,iter=50,m_start=4,test=FALSE,validation=FALSE,criterion="aic")
plot(sem_disc)
}
\concept{test discretization plot}
