% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{glmaag}
\alias{glmaag}
\title{Fit glmaag model}
\usage{
glmaag(y, x, L, tune = F, est = T, gam = 1, lam1, lam2, nfolds = 5,
  dfmax, w0, adaptl1 = T, adaptl2 = T, pind, intercept = T,
  standardize = T, maxiter = 10000, cri = 0.001, fam = "Gaussian",
  measdev = T, type1se = T, parallel = F)
}
\arguments{
\item{y}{outcome}

\item{x}{predictors matrix}

\item{L}{Laplacian matrix for the network}

\item{tune}{whether to tune with an estimated network, default to be FALSE}

\item{est}{whether to estimate a network from the data}

\item{gam}{the parameter for l1 adaptive weight, default to be ones}

\item{lam1}{The tuning parameters for L1 penalty. If not defined, searched by default}

\item{lam2}{The tuning parameters for quadratic penalty. If not defined, searched by default}

\item{nfolds}{number of folds used in cross validation to obatin network sign estimate and l1 weight estimate, default to be five}

\item{dfmax}{maximum number of parameters allowed in the model, default to be p/2}

\item{w0}{Weights for l1 penalty. If not defined, estimated via quadratic penalyzed regression}

\item{adaptl1}{whether to adapt the l1 penalty, default to be TRUE}

\item{adaptl2}{whether to adapt the sign for quadratic penalty, default to be TRUE}

\item{pind}{indicator vector whether to put L1 penalty on the feature, 1 means penalyzed while 0 means not penalyzed, default to be all ones (all penalyzed)}

\item{intercept}{whether to include intercept. Ignore for Cox regression}

\item{standardize}{whether to standardize predictors}

\item{maxiter}{maximum number of iterations, default to be 500}

\item{cri}{stoppint criterion, default to be 0.001}

\item{fam}{family for the outcome, can be "Gaussian", "Logistic", and "Cox"}

\item{measdev}{Whether to use deviance to tune when estimate l1 weight and network sign, default to be deviance. If not, use mean absolue error, area under ROC curve, or concordance index for Gaussian, Logistic, and Cox}

\item{type1se}{whether to use one standard error or maximum rule when estimate network sign and l1 weight, default to be one standard error rule}

\item{parallel}{whether to do parallel computing at each lambda2, need to set up parallel first, default to be FALSE}
}
\value{
\item{input}{input predictors}

\item{lambda1}{l1 penalty parameter search sequence}

\item{lambda2}{quadratic penalty parameter search sequence}

\item{ns}{number of parameters selected given provided tuning parameter}

\item{coefs}{coefficients estimated}

\item{intercept}{intercepts estimated}

\item{loglik}{log likelihood estimated}

\item{fam}{family of the outcome}
}
\description{
Fit the glmaag model with given tuning parameters without cross validation or stability selection
}
\examples{
data(sampledata)
data(L0)
y <- sampledata$Y_Gau
x <- sampledata[, -(1:3)]
mod <- glmaag(y, x, L0)
}
