% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.gllvm.R
\name{anova.gllvm}
\alias{anova.gllvm}
\title{Analysis Of Deviance for gllvm}
\usage{
\method{anova}{gllvm}(object, ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{...}{one or more objects of class 'gllvm'}
}
\description{
Compute an analysis of deviance table for two or more generalized linear latent variable model fits.
}
\details{
Computes likelihood-ratio test for two or more gllvm models.
Test results makes sense only for nested models.
Notice also that this test was not designed for tests which have df difference larger than 20,
so for those tests the P-value should be treated as very approximate.
}
\examples{
## Load a dataset from the mvabund package
data(antTraits)
y <- antTraits$abund
X <- antTraits$env
TR <- antTraits$traits
# Fit gllvm model
fit1 <- gllvm(y, X, TR, formula = ~ Bare.ground+Shrub.cover
             +Webers.length, family = "poisson")
fit2 <- gllvm(y, X, TR, formula = ~ (Bare.ground+Shrub.cover)*
             Webers.length, family = "poisson")
# Let's test the need for fourth corner interaction terms using likelihood-ratio test:
anova(fit1, fit2)

}
\author{
Jenni Niku
}
