% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getf0.R
\name{getf0}
\alias{getf0}
\title{f0 optimization routine}
\usage{
getf0(y, spt, ySptIndex, sptFreq, sampprobs, mu, mu0, f0Start, thStart,
  thetaControl = theta.control(), f0Control = f0.control(), trace = FALSE)
}
\arguments{
\item{y}{Vector of response values.}

\item{spt}{Vector of unique observed support points in the response.}

\item{ySptIndex}{Index of each \code{y} value within \code{spt}.}

\item{sptFreq}{Vector containing frequency of each \code{spt} value.}

\item{sampprobs}{Optional matrix of sampling probabilities.}

\item{mu}{Fitted mean for each observation. Only used if \code{sampprobs=NULL}.}

\item{mu0}{Mean constraing for f0.}

\item{f0Start}{Starting f0 values. (Typically the estimate from the previous
iteration.)}

\item{thStart}{Starting theta values. Needs to be a list of values matching
the output of the \code{getTheta} function.}

\item{thetaControl}{A "thetaControl" object returned from the \code{theta.control}
function.}

\item{f0Control}{An "f0Control" object returned from the \code{f0.control}
function.
trace Logical. If TRUE, then progress is printed to terminal at each iteration.}
}
\value{
A list containing the following:
\itemize{
\item \code{f0} Updated values.
\item \code{llik} Updated log-likelihood.
\item \code{th} Updated list returned from the \code{getTheta} function.
\item \code{conv} Convergence indicator.
\item \code{iter} Number of iterations until convergence.
\item \code{nhalf} The number of half steps taken on the last iteration if the
initial BFGS update did not improve the log-likelihood.
\item \code{score.log} Score function with respect to log(f0) at convergence.
\item \code{info.log} Information matrix with respect to log(f0) at convergence.
}
}
\description{
f0 optimization routine
}
\keyword{internal}
